/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen.indent;

import java.lang.reflect.Modifier;
import java.util.Collections;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 * Tests indentation of newly generated body text in method.
 *
 * @author Pavel Flaska
  */
public class MethodBodyTextTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    /** Creates a new instance of MethodBodyTextTest */
    public MethodBodyTextTest() {
        super("MethodBodyTextTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(MethodBodyTextTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.codegen.indent.MethodBodyText");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    public void testSetBodyText() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Method m = (Method) clazz.getContents().get(0);
            m.setBodyText("\n\n// nothing\n");
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/MethodBodyText.java"),
            getGoldenFile("testSetBodyText_MethodBodyTextTest.pass"),
            getWorkDir()
        );
    }

    public void testCreateWithBodyText() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        StringBuffer body = new StringBuffer();
        body.append("\n// TODO add your own implementation\n\n\n");
        try {
            Method m = pkg.getMethod().createMethod(
                    "method2",
                    Collections.EMPTY_LIST,
                    Modifier.PUBLIC,
                    null, // javadoc text
                    null, // javadoc
                    null, // object body
                    body.toString(), // string body
                    Collections.EMPTY_LIST, // type params
                    Collections.EMPTY_LIST, // parameters
                    Collections.EMPTY_LIST, // exceptions
                    pkg.getMultipartId().createMultipartId("void", null, null), // type
                    0);

            clazz.getContents().add(m);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/MethodBodyText.java"),
            getGoldenFile("testCreateWithBodyText_MethodBodyTextTest.pass"),
            getWorkDir()
        );
    }
    
    public void testModifyBodyText() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Method m = (Method) clazz.getContents().get(1);
            m.setBodyText(m.getBodyText() + "// TODO no new lines around");
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/MethodBodyText.java"),
            getGoldenFile("testModifyBodyText_MethodBodyTextTest.pass"),
            getWorkDir()
        );
    }
}
