/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen.indent;
import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.Catch;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.NewClassExpression;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.StatementBlockClass;
import org.netbeans.jmi.javamodel.TryStatement;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 * Tests indentation of newly generated elements.
 *
 * @author Pavel Flaska
 */
public class Indent1Test extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    /** Creates a new instance of Indent1Test */
    public Indent1Test() {
        super("Indent1Test");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(Indent1Test.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.codegen.indent.Indent1");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    /**
     * Creates the body in constructor:
     *
     * <code>
     * public Indent1() {
     *   try {
     *       ;
     *   } catch (java.lang.Exception e) {
     *       ;
     *   } finally {
     *       ;
     *  }
     * </code>
     *
     */
    public void testIndentTryBlock() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Constructor constructor = (Constructor) clazz.getContents().get(0);
            List statements = constructor.getBody().getStatements();
            StatementBlockClass sbc = pkg.getStatementBlock();
            Parameter p = pkg.getParameter().createParameter("e", null, false, pkg.getMultipartId().createMultipartId("java.lang.Exception", null, null), 0, false);
            StatementBlock bodyBody = sbc.createStatementBlock();
            bodyBody.getStatements().add(pkg.getEmptyStatement().createEmptyStatement());
            StatementBlock finallyBody = sbc.createStatementBlock();
            finallyBody.getStatements().add(pkg.getEmptyStatement().createEmptyStatement());
            StatementBlock catchBody = sbc.createStatementBlock();
            catchBody.getStatements().add(pkg.getEmptyStatement().createEmptyStatement());
            statements.add(pkg.getTryStatement().createTryStatement(bodyBody, Collections.singletonList(pkg.getCatch().createCatch(p, catchBody)), finallyBody));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/Indent1.java"),
            getGoldenFile("testIndentTryBlock_Indent1Test.pass"),
            getWorkDir()
        );
    }

    /**
     * Adds new <code>throw</code> statement to catch section:
     *
     * <code>
     *   } catch (java.lang.Exception e) {
     *       ;
     *       throw new Throwable("Bad day!");
     *   } finally {
     * </code>
     */
    public void testThrowsStatement() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true; 
        Utility.beginTrans(true);
        try {
            Constructor constructor = (Constructor) clazz.getContents().get(0);
            List catches = ((TryStatement) constructor.getBody().getStatements().get(0)).getCatches();
            List catchBodyStmts = ((Catch) catches.get(0)).getBody().getStatements();
            NewClassExpression e = pkg.getNewClassExpression().createNewClassExpression(
                    "Throwable", 
                    Collections.singletonList(pkg.getStringLiteral().createStringLiteral("Bad day!")),
                    null,
                    null,
                    null
                    );
            catchBodyStmts.add(1, pkg.getThrowStatement().createThrowStatement(e));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/Indent1.java"),
            getGoldenFile("testThrowStatement_Indent1Test.pass"),
            getWorkDir()
        );
    }
}
