/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen.indent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author Pavel Flaska
 */
public class ImportFormatTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    /** Creates a new instance of ImportFormatTest */
    public ImportFormatTest() {
        super("ImportFormatTest");
    }

    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(ImportFormatTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.codegen.indent.imports.ImportClass1");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    public void testFirstAddition() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List/*<Import>*/ imports = clazz.getResource().getImports();
            imports.add(createImport("java.util.List"));
            imports.add(createImport("java.util.Set"));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/imports/ImportClass1.java"),
            getGoldenFile("testFirstAddition_ImportFormatTest.pass"),
            getWorkDir()
        );
    }
    
    public void testAddFirstImport() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List/*<Import>*/ imports = clazz.getResource().getImports();
            imports.add(0, createImport("java.util.AbstractList"));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/imports/ImportClass1.java"),
            getGoldenFile("testAddFirstImport_ImportFormatTest.pass"),
            getWorkDir()
        );
    }
    
    public void testAddLastImport() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List/*<Import>*/ imports = clazz.getResource().getImports();
            imports.add(createImport("java.io.IOException"));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/imports/ImportClass1.java"),
            getGoldenFile("testAddLastImport_ImportFormatTest.pass"),
            getWorkDir()
        );
    }
    
    public void testRemoveInnerImport() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List/*<Import>*/ imports = clazz.getResource().getImports();
            getLog().print(imports.size());
            imports.remove(1);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/imports/ImportClass1.java"),
            getGoldenFile("testRemoveInnerImport_ImportFormatTest.pass"),
            getWorkDir()
        );
    }
    
    public void testRemoveFirstImport() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List/*<Import>*/ imports = clazz.getResource().getImports();
            getLog().print(imports.size());
            imports.remove(0);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/imports/ImportClass1.java"),
            getGoldenFile("testRemoveFirstImport_ImportFormatTest.pass"),
            getWorkDir()
        );
    }
    
    public void testRemoveLastImport() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List/*<Import>*/ imports = clazz.getResource().getImports();
            getLog().print(imports.size());
            imports.remove(1);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/imports/ImportClass1.java"),
            getGoldenFile("testRemoveLastImport_ImportFormatTest.pass"),
            getWorkDir()
        );
    }
    
    public void testRemoveAllRemaning() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List/*<Import>*/ imports = clazz.getResource().getImports();
            getLog().print(imports.size());
            imports.clear();
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/imports/ImportClass1.java"),
            getGoldenFile("testRemoveAllRemaning_ImportFormatTest.pass"),
            getWorkDir()
        );
    }

    public void testAddSeveral() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List/*<Import>*/ imports = clazz.getResource().getImports();
            imports.add(createImport("java.util.List"));
            imports.add(createImport("java.util.Set"));
            imports.add(createImport("javax.swing.CellRendererPane"));
            imports.add(createImport("javax.swing.BorderFactory"));
            imports.add(createImport("javax.swing.ImageIcon"));
            imports.add(createImport("javax.swing.InputVerifier"));
            imports.add(createImport("javax.swing.GrayFilter"));
            imports.add(createImport("javax.swing.JFileChooser"));
            imports.add(createImport("javax.swing.AbstractAction"));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/imports/ImportClass1.java"),
            getGoldenFile("testAddSeveral_ImportFormatTest.pass"),
            getWorkDir()
        );
    }
    
    public void testRemoveInside() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List/*<Import>*/ imports = clazz.getResource().getImports();
            imports.remove(4);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/imports/ImportClass1.java"),
            getGoldenFile("testRemoveInside_ImportFormatTest.pass"),
            getWorkDir()
        );
    }
    
    public void testMoveFirst() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List/*<Import>*/ imports = clazz.getResource().getImports();
            Object first = imports.remove(0);
            imports.add(3, first);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/imports/ImportClass1.java"),
            getGoldenFile("testMoveFirst_ImportFormatTest.pass"),
            getWorkDir()
        );
    }
    
    public void testMoveLast() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List/*<Import>*/ imports = clazz.getResource().getImports();
            Object o = imports.remove(7);
            imports.add(1, o);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/imports/ImportClass1.java"),
            getGoldenFile("testMoveLast_ImportFormatTest.pass"),
            getWorkDir()
        );
    }
    
    public void testReplaceLine() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List/*<Import>*/ imports = clazz.getResource().getImports();
            Object first = imports.remove(4);
            imports.add(4, createImport("java.util.Collection"));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/imports/ImportClass1.java"),
            getGoldenFile("testReplaceLine_ImportFormatTest.pass"),
            getWorkDir()
        );
    }

    public void testSort() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List/*<Import>*/ imports = clazz.getResource().getImports();
            List copy = new ArrayList(imports);
            Collections.sort(copy, new Comparator() {
                public int compare(Object o1, Object o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    Import i1 = (Import) o1;
                    Import i2 = (Import) o2;
                    
                    return i1.getIdentifier().getType().getName().compareTo(i2.getIdentifier().getType().getName());
                }
                
                public boolean equals(Object obj) {
                    return this == obj ? true : false;
                }
            });
            for (Iterator it = copy.iterator(); it.hasNext(); ) {
                getLog().println(((Import) it.next()).getIdentifier().getType().getName());
            }
            imports.clear();
            imports.addAll(copy);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/imports/ImportClass1.java"),
            getGoldenFile("testSort_ImportFormatTest.pass"),
            getWorkDir()
        );
    }
    
    // has to be called transaction!!!
    private Import createImport(String importSymbol) {
        //MultipartId id = pkg.getMultipartId().createMultipartId(importSymbol, null, null);
        return pkg.getImport().createImport(importSymbol, null, false, false);
    }
}
