/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen.indent;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 * Tests indentation of newly generated elements.
 *
 * @author Pavel Flaska
 */
public class AnnIndentTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    /** Creates a new instance of AnnIndentTest */
    public AnnIndentTest() {
        super("AnnIndentTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(AnnIndentTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.codegen.indent.AnnIndentClass");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    public void testAddAnnotations() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Method m = (Method) clazz.getContents().get(1);
            MultipartId type1 = pkg.getMultipartId().createMultipartId("Deprecated()", null, Collections.EMPTY_LIST);
            MultipartId type2 = pkg.getMultipartId().createMultipartId("Deprecated2()", null, Collections.EMPTY_LIST);
            Annotation ann1 = pkg.getAnnotation().createAnnotation(type1, Collections.EMPTY_LIST);
            Annotation ann2 = pkg.getAnnotation().createAnnotation(type2, Collections.EMPTY_LIST);
            m.getAnnotations().add(ann1);
            m.getAnnotations().add(ann2);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/AnnIndentClass.java"),
            getGoldenFile("testAddAnnotations_AnnIndentTest.pass"),
            getWorkDir()
        );
    }
    
    public void testAddAnnotationsToClass() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            MultipartId type1 = pkg.getMultipartId().createMultipartId("Deprecated()", null, Collections.EMPTY_LIST);
            MultipartId type2 = pkg.getMultipartId().createMultipartId("Deprecated2()", null, Collections.EMPTY_LIST);
            Annotation ann1 = pkg.getAnnotation().createAnnotation(type1, Collections.EMPTY_LIST);
            Annotation ann2 = pkg.getAnnotation().createAnnotation(type2, Collections.EMPTY_LIST);
            clazz.getAnnotations().add(ann1);
            clazz.getAnnotations().add(ann2);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/AnnIndentClass.java"),
            getGoldenFile("testAddAnnotationsToClass_AnnIndentTest.pass"),
            getWorkDir()
        );
    }
    
    public void testAddAnnotationWithMethod() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            MultipartId type1 = pkg.getMultipartId().createMultipartId("Deprecated()", null, Collections.EMPTY_LIST);
            MultipartId type2 = pkg.getMultipartId().createMultipartId("Deprecated2()", null, Collections.EMPTY_LIST);
            Annotation ann1 = pkg.getAnnotation().createAnnotation(type1, Collections.EMPTY_LIST);
            Annotation ann2 = pkg.getAnnotation().createAnnotation(type2, Collections.EMPTY_LIST);
            List annList = new ArrayList();
            annList.add(ann1);
            annList.add(ann2);
            Method m = pkg.getMethod().createMethod("newMethod", annList, Modifier.PUBLIC, null, null, null, null, null, null, null, 
                    pkg.getMultipartId().createMultipartId("void", null, null), 0);
            clazz.getContents().add(m);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/AnnIndentClass.java"),
            getGoldenFile("testAddAnnotationWithMethod_AnnIndentTest.pass"),
            getWorkDir()
        );
    }
    
    public void testAddAnnotationWithClass() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            MultipartId type1 = pkg.getMultipartId().createMultipartId("Deprecated()", null, Collections.EMPTY_LIST);
            MultipartId type2 = pkg.getMultipartId().createMultipartId("Deprecated2()", null, Collections.EMPTY_LIST);
            Annotation ann1 = pkg.getAnnotation().createAnnotation(type1, Collections.EMPTY_LIST);
            Annotation ann2 = pkg.getAnnotation().createAnnotation(type2, Collections.EMPTY_LIST);
            List annList = new ArrayList();
            annList.add(ann1);
            annList.add(ann2);
            JavaClass javaClass = pkg.getJavaClass().createJavaClass("SecondTop", annList, 0, null, null, Collections.EMPTY_LIST, null, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
            clazz.getResource().getClassifiers().add(javaClass);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/indent/AnnIndentClass.java"),
            getGoldenFile("testAddAnnotationWithClass_AnnIndentTest.pass"),
            getWorkDir()
        );
    }

}
