/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel.codegen;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.MultipartId;
import java.io.IOException;
import java.util.Iterator;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.TypeReference;
import org.openide.filesystems.FileStateInvalidException;

/**
 * 
 *
 * @author  Pavel Flaska
 */
public class VarArgsTest extends NbTestCase {
    
    /** Creates a new instance of VarArgsTest */
    public VarArgsTest() {
        super("VarArgsTest");
    }

    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(VarArgsTest.class);
        return suite;
    }
    
    private JavaModelPackage pkg;
    private JavaClass clazz;
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.VarArgsClass");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    public void testCreation() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            // private boolean newlyCreated(String... varString) {
            //     return true;
            // }
            MultipartId typeName = pkg.getMultipartId().createMultipartId("boolean", null, null);
            MultipartId parType = pkg.getMultipartId().createMultipartId("String", null, null);
            Parameter par = pkg.getParameter().createParameter(
                "varString",      // name
                null,             // annotations
                false,            // is final?
                parType,          // parameter's type
                0,                // dimCount
                true              // is variable arguments?
            );
            Method newMethod = pkg.getMethod().createMethod(
                "newlyCreated",                  // method name
                null,                            // annotations
                Modifier.PRIVATE,                // modifiers
                null,                            // javadocText
                null,                            // javadoc
                null,                            // body
                "return true;",                  // bodyText
                null, 
                Collections.singletonList(par),  // parameters
                Collections.EMPTY_LIST,          // exception names
                typeName,                        // return type
                0                                // dimCount
            );
            clazz.getFeatures().add(newMethod);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/VarArgsClass.java"),
            getGoldenFile("testCreation_VarArgsTest.pass"),
            getWorkDir()
        );
    }
    
    public void testParAdd() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            // public void addVarPar(int c, Object... varObject) {
            // }
            MultipartId parType = pkg.getMultipartId().createMultipartId("Object", null, null);
            Parameter par = pkg.getParameter().createParameter(
                "varObject",     // name
                null,            // annotations
                false,           // is final?
                parType,         // parameter's type
                0,               // dimCount
                true             // is variable arguments?
            );
            Method method = (Method) clazz.getContents().get(0);
            List pars = method.getParameters();
            pars.add(par);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/VarArgsClass.java"),
            getGoldenFile("testParAdd_VarArgsTest.pass"),
            getWorkDir()
        );
    }
    
    public void testParChange() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            // public int changeVarPar(long... varLong) {
            //     return 10;
            // }
            Type type = pkg.getType().resolve("long");
            Method method = (Method) clazz.getContents().get(1);
            Parameter par = (Parameter) method.getParameters().get(0);
            par.setType(type);
            par.setName("varLong");
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/VarArgsClass.java"),
            getGoldenFile("testParChange_VarArgsTest.pass"),
            getWorkDir()
        );
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
}
