/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.jmi.javamodel.codegen;

import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.JavaClass;
import java.io.IOException;
import java.util.Iterator;
import junit.textui.TestRunner;
import org.openide.filesystems.FileStateInvalidException;

/**
 * Tests the static imports as they are defined in JSR201 and implemented
 * in JDK 1.5.
 *
 * @author  Pavel Flaska
 */
public class StaticImportTest extends NbTestCase {
    
    /** Creates a new instance of StaticImportTest */
    public StaticImportTest() {
        super("StaticImportTest");
    }

    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(StaticImportTest.class);
        return suite;
    }
    
    JavaModelPackage pkg;
    JavaClass clazz;
    Import arraysImport;
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.StaticImport");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        for (Iterator it = clazz.getResource().getImports().iterator(); it.hasNext(); ) {
            arraysImport = (Import) it.next();
        }
    }
    
    public void testCreation() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Resource res = clazz.getResource();
            Import i = pkg.getImport().createImport("java.util.Collections", null, true, false);
            res.getImports().add(i);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/StaticImport.java"),
            getGoldenFile("testCreation_StaticImport.pass"),
            getWorkDir()
        );
    }
    
    public void testCreation2() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Resource res = clazz.getResource();
            arraysImport = pkg.getImport().createImport("java.util.Arrays", null, false, false);
            res.getImports().add(arraysImport);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/StaticImport.java"),
            getGoldenFile("testCreation2_StaticImport.pass"),
            getWorkDir()
        );
    }
    
    public void testSetStatic() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            arraysImport.setStatic(true);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/StaticImport.java"),
            getGoldenFile("testSetStatic_StaticImport.pass"),
            getWorkDir()
        );
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
}
