/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen.RenameTests;

import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Assignment;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.ExpressionStatement;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.ForStatement;
import org.netbeans.jmi.javamodel.IfStatement;
import org.netbeans.jmi.javamodel.InfixExpression;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Literal;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.NewClassExpression;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.jmi.javamodel.codegen.CodegenTestCase;
import org.netbeans.junit.NbTestSuite;

/**
 * Tests re-generating of names in different elements.
 *
 * @author  Pavel Flaska
 */
public class RenameTestMethod extends CodegenTestCase {
    
    /** Need to be defined because of JUnit */
    public RenameTestMethod(String name) {
        super(name, "RenameTestMethod");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new RenameTestMethod("testRename"));
        return suite;
    }
    
    JavaClass clazz;
    JavaModelPackage pkg;
    Feature[] feature = new Feature[5];

    private static final String newName = "renamedMethod";
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.RenameTestMethod");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        // initialize methods
        int i = 0;
        for (Iterator fIt = clazz.getFeatures().iterator(); fIt.hasNext(); i++) {
            feature[i] = (Feature) fIt.next();
        }
    }
    
    public void testRename() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            feature[2].setName(newName);
            
            Method callerMethod = (Method) feature[3];
            StatementBlock body = callerMethod.getBody();
            List st = body.getStatements();
            
            // int a = methodToBeRenamed(5);
            LocalVarDeclaration lvd = (LocalVarDeclaration) st.get(0);
            LocalVariable lv = (LocalVariable) lvd.getVariables().get(0);
            MethodInvocation mi = (MethodInvocation) lv.getInitialValue();
            mi.setName(newName);

            // a = methodToBeRenamed(5) - methodToBeRenamed(4);
            Assignment ass = (Assignment) ((ExpressionStatement) st.get(1)).getExpression();
            InfixExpression infx = (InfixExpression) ass.getRightSide();
            mi = (MethodInvocation) infx.getLeftSide();
            mi.setName(newName);
            mi = (MethodInvocation) infx.getRightSide();
            mi.setName(newName);
            
            // if (a != 0) {
            //      methodToBeRenamed(methodToBeRenamed(c));
            // }
            IfStatement ifstmt = (IfStatement) st.get(2);
            StatementBlock block = (StatementBlock) ifstmt.getThenPart();
            mi = (MethodInvocation) ((ExpressionStatement) block.getStatements().get(0)).getExpression();
            mi.setName(newName);
            mi = (MethodInvocation) mi.getParameters().get(0);
            mi.setName(newName);
            
            callerMethod = (Method) feature[4];
            body = callerMethod.getBody();
            
            // new RenameTestMethod().methodToBeRenamed(11);
            mi = (MethodInvocation) ((ExpressionStatement) body.getStatements().get(0)).getExpression();
            mi.setName(newName);
            
            fail = false;
            
        }
        finally  {
            Utility.endTrans(fail);
        }
        makeDiff("testRename");
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
