/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen.RenameTests;

import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Assignment;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.ExpressionStatement;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.ForStatement;
import org.netbeans.jmi.javamodel.IfStatement;
import org.netbeans.jmi.javamodel.InfixExpression;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Literal;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.NewClassExpression;
import org.netbeans.jmi.javamodel.ReturnStatement;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeCast;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.jmi.javamodel.codegen.CodegenTestCase;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestSuite;

/**
 * Tests re-generating of names in different elements.
 *
 * @author  Pavel Flaska
 */
public class RenameTestClass extends CodegenTestCase {
    
    /** Need to be defined because of JUnit */
    public RenameTestClass(String name) {
        super(name, "RenameTestClass");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new RenameTestClass("testRename"));
        return suite;
    }
    
    JavaClass clazz;
    JavaModelPackage pkg;
    Feature[] feature = new Feature[4];

    private static final String newName = "RenamedClass";
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.RenameTestClass");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        // initialize methods
        int i = 0;
        for (Iterator fIt = clazz.getFeatures().iterator(); fIt.hasNext(); i++) {
            feature[i] = (Feature) fIt.next();
        }
    }
    
    public void testRename() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            ((JavaClass) feature[3]).setSimpleName(newName);
            JavaClass inner = (JavaClass) pkg.getType().resolve("org.netbeans.test.codegen.RenameTestClass.RenamedClass");
            // private ClassToRename renamedCl;
            Field field = (Field) feature[0];
            field.getTypeName().setName(newName);

            // find constructor
            Constructor constructor = (Constructor) feature[1];
            StatementBlock body = constructor.getBody();
            List statement = body.getStatements();
            // renamedCl = new ClassToRename(5);
            Assignment asi = (Assignment) ((ExpressionStatement) statement.get(0)).getExpression();
            NewClassExpression nce = (NewClassExpression) asi.getRightSide();
            nce.getClassName().setName(newName);
            
            // get method
            Method method = (Method) feature[2];
            body = method.getBody();
            statement = body.getStatements();
            // set return type
            method.getTypeName().setName(newName);
            // ClassToRename confusingVar;
            LocalVarDeclaration lvd = (LocalVarDeclaration) statement.get(0);
            lvd.getTypeName().setName(newName);
            // ClassToRename result = (ClassToRename) confusingVar;
            lvd = (LocalVarDeclaration) statement.get(2);
            lvd.getTypeName().setName(newName);
            LocalVariable lv = (LocalVariable) lvd.getVariables().get(0);
            TypeCast typeCast = (TypeCast) lv.getInitialValue();
            typeCast.getTypeName().setName(newName);
            // return new ClassToRename(x);
            ReturnStatement retSt = (ReturnStatement) statement.get(4);
            nce = (NewClassExpression) retSt.getExpression();
            nce.getClassName().setName(newName);
            
            fail = false;
            
        }
        finally  {
            Utility.endTrans(fail);
        }
        makeDiff("testRename");
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }   
    
}
