/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import java.io.File;
import java.lang.InterruptedException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.RefPackage;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.classpath.MergedClassPathImplementation;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

/**
 *
 * @author Pavel Flaska
 */
public class PreScanTest extends NbTestCase {

    private static final String[] jdks  = {
        // "/usr/java/j2sdk1.4.2_04/",
        // "/usr/java/j2sdk1.4.2_05/",
        "/usr/java/jdk1.5.0_02/"
    };

    /**
     * Creates a new instance of PreScanTest 
     */
    public PreScanTest() {
        super("PreScanTest");
    }
    
    protected void setUp() {
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(PreScanTest.class);
        return suite;
    }
    
    public void testPrebuildStorage() throws FileStateInvalidException, MalformedURLException {
        for (int i = 0; i < jdks.length; i++) {
            preparseFile(jdks[i] + "jre/lib/rt.jar", "rt", false); // NOI18N
            preparseFile(jdks[i] + "src.zip", "src", true); // NOI18N
        }
    }
    
    private void preparseFile(String filename, String type, boolean preparseFeatures) throws FileStateInvalidException, MalformedURLException {
        File file = new File(filename);
        FileObject archive = FileUtil.toFileObject(file);
        FileObject archiveRoot = FileUtil.getArchiveRoot(archive);
        URL archiveUrl = archiveRoot.getURL();
        MergedClassPathImplementation.getDefault().addRoot(archiveUrl);
        ((JMManager) JMManager.getManager()).waitScanFinished();
        // pre-parse
        String saveToDir = System.getProperty("netbeans.home") + "/mdrstorage/";
        NBMDRepositoryImpl impl = (NBMDRepositoryImpl) JavaMetamodel.getDefaultRepository();
        if (preparseFeatures) {
            impl.beginTrans(true);
            impl.disableEvents();
            try {
                JavaModelPackage javaPckg = JavaMetamodel.getManager().getJavaExtent(archiveRoot);
                long start = System.currentTimeMillis();
                ResourceImpl[] resources = (ResourceImpl[]) javaPckg.getResource().refAllOfClass().toArray(new ResourceImpl[0]);
                MOFID[] mofids = new MOFID[resources.length];
                for (int i = 0; i < resources.length; i++) {
                    mofids[i] = resources[i]._getMofId();
                }
                resources = null;
                int printed = 0;
                for (int i = 0; i < mofids.length; i++) {
                    Resource r = (Resource) impl.getByMofId(mofids[i]);
                    r.getImports();
                    int perCent = i*100/mofids.length;
                    if (perCent > printed) {
                        printed = perCent;
                        System.err.println(printed + "% completed.\r");
                    }
                    impl.endTrans();
                    impl.beginTrans(true);
                    impl.disableEvents();
                }
                System.err.println(filename + " contains " + mofids.length + " classes.");
                System.err.println(filename + " took " + (System.currentTimeMillis() - start) + " ms.");
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                impl.endTrans();
            }
        }
        impl.beginTrans(true);
        impl.disableEvents();
        try {
            String hash = JMManager.computePreparsedHash(file, JMManager.BYTES4MD5);
            String uri = ((JMManager) JMManager.getManager()).getRootURI(archiveRoot);
            RefPackage extent = (JavaModelPackage) impl.getExtent("codebase:" + uri);
            impl.renameExtent(extent, "codebase:" + type);
            JMManager m = (JMManager) JMManager.getManager();
            String strName = m.getFileName(m.getValidName(m.getRootURI(archiveRoot)));
            System.err.print("cp " + strName + ".btd ");
            System.err.println(saveToDir + type + "-" + hash + ".btd");
            System.err.print("cp " + strName + ".btx ");
            System.err.println(saveToDir + type + "-" + hash + ".btx");
            System.err.print("cp " + strName + ".cdx ");
            System.err.println(saveToDir + type + "-" + hash + ".cdx");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            impl.endTrans();
        }
    }
    
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
}
