/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen.MethodTest1;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestSuite;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.codegen.CodegenTestCase;
import org.netbeans.jmi.javamodel.codegen.Utility;

/**
 * Tests the method generator.
 *
 * @author  Pavel Flaska
 */
public class MethodTest1 extends CodegenTestCase {
    
    /** Need to be defined because of JUnit */
    public MethodTest1(String name) {
        super(name, "MethodTest1");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new MethodTest1("testMethodModifiers"));
        suite.addTest(new MethodTest1("testMethodName"));
        suite.addTest(new MethodTest1("testMethodParameters"));
        suite.addTest(new MethodTest1("testMethodParameterChange"));
        suite.addTest(new MethodTest1("testMethodThrows"));
        suite.addTest(new MethodTest1("testMethodReturnType"));
        suite.addTest(new MethodTest1("testMethodBody"));
        suite.addTest(new MethodTest1("testParameterizedMethod"));
        suite.addTest(new MethodTest1("testAddRemoveInOneTrans"));
        return suite;
    }
    
    JavaClass clazz;
    JavaModelPackage pkg;
    Method[] method = new Method[10];
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.MethodTest1");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        // initialize methods
        int i = 0;
        for (Iterator mIt = clazz.getFeatures().iterator(); mIt.hasNext(); i++) {
            Object temp = mIt.next();
            if (temp instanceof JavaClass) {
                method[i] = (Method) ((JavaClass) temp).getFeatures().get(0);
            } else {
                method[i] = (Method) temp;
            }
        }
    }

    /**
     * Changes the modifiers on method. Removes public modifier, sets static
     * and private modifier.
     */
    public void testMethodModifiers() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            int modifiers = method[0].getModifiers();
            modifiers &= ~Modifier.PUBLIC;
            modifiers |= Modifier.STATIC;
            modifiers |= Modifier.PRIVATE;
            method[0].setModifiers(modifiers);
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        makeDiff("testMethodModifiers");
    }

    /**
     * Changes the name on the method.
     */
    public void testMethodName() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            method[1].setName("druhaMetoda");
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        makeDiff("testMethodName");
    }
    
    /**
     * Removes the first parameter and adds it to the end
     */
    public void testMethodParameters() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List parameters = method[2].getParameters();
            Parameter par = (Parameter) parameters.remove(0);
            parameters.add(par);
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        makeDiff("testMethodParameters");
    }
    
    /**
     * Changes the name of the parameter.
     */
    public void testMethodParameterChange() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List parameters = method[3].getParameters();
            Parameter par = (Parameter) parameters.get(0);
            par.setName("aParNewName");
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        makeDiff("testMethodParameterChange");
    }

    /**
     * Removes first exception thrown, adds another one to the end.
     */
    public void testMethodThrows() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            List exceptions = method[4].getExceptionNames();
            exceptions.remove(0);
            exceptions.add(pkg.getMultipartId().createMultipartId("java.lang.IllegalMonitorStateException", null, null));
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        makeDiff("testMethodThrows");
    }
    
    /**
     * Changes return type to String.
     */
    public void testMethodReturnType() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            method[5].setTypeName(pkg.getMultipartId().createMultipartId("String", null, null));
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        makeDiff("testMethodReturnType");
    }

    /**
     * Tests method body.
     */
    public void testMethodBody() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            method[6].setModifiers(Modifier.PUBLIC);
            method[6].setBody(pkg.getStatementBlock().createStatementBlock());
            method[7].setModifiers(Modifier.PUBLIC | Modifier.ABSTRACT);
            method[7].setBody(null);
            method[8].getBody();
            method[8].getExceptionNames().add(pkg.getMultipartId().createMultipartId("java.io.IOException", null, null));
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        makeDiff("testMethodBody");
    }
    
    public void testParameterizedMethod() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            TypeParameter typePar = pkg.getTypeParameter().createTypeParameter();
            typePar.setName("T");
            // create parameter "T cl"
            Parameter param = pkg.getParameter().createParameter();
            param.setName("cl");
            param.setType(typePar);
            // create the method

            Method method = pkg.getMethod().createMethod(
                "getIt",
                Collections.EMPTY_LIST,
                Modifier.PUBLIC,
                "new method",
                null, // jvadoc
                null, // object body
                "return null;", // string body
                Collections.singletonList(typePar), // type params
                Collections.singletonList(param), // parameters
                null, // exceptions
                null, // type
                0);
            method.setType(typePar);
            fail = false;
            clazz.getContents().add(method);
        }
        finally  {
            Utility.endTrans(fail);
        }
        makeDiff("testParameterizedMethod");
    }
    
    public void testAddRemoveInOneTrans() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            TypeParameter typePar = pkg.getTypeParameter().createTypeParameter();
            typePar.setName("T2");
            // create parameter "T newPar"
            Parameter param = pkg.getParameter().createParameter();
            param.setName("newPar");
            param.setType(typePar);
            // create the method

            Method method = pkg.getMethod().createMethod(
                "setIt",
                Collections.EMPTY_LIST,
                Modifier.PUBLIC,
                "new javadoc",
                null, // jvadoc
                null, // object body
                "return null;", // string body
                Collections.singletonList(typePar), // type params
                Collections.singletonList(param), // parameters
                null, // exceptions
                null, // type
                0);
            method.setType(typePar);
            fail = false;
            List/*<Feature>*/ features = clazz.getContents();
            features.remove(features.size()-1);
            features.add(method);
        }
        finally  {
            Utility.endTrans(fail);
        }
        makeDiff("testAddRemoveInOneTrans");
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
}
