/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.JavaClass;
import java.io.IOException;
import java.util.Iterator;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Feature;
import org.openide.filesystems.FileStateInvalidException;

/**
 * Tests the JavaDocText code-generation.
 *
 * @author  Pavel Flaska
 */
public class JavaDocTest extends NbTestCase {
    
    JavaModelPackage pkg;
    JavaClass clazz;
    
    /** Creates a new instance of JavaDocTest */
    public JavaDocTest() {
        super("JavaDocTest");
    }

    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(JavaDocTest.class);
        return suite;
    }

    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.JavaDocTestClass");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    public void testAddJavaDocText() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            ((Feature) clazz.getContents().get(0)).setJavadocText("JavaDoc for the firstMethod.");
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/JavaDocTestClass.java"),
            getGoldenFile("testAddJavaDocText_JavaDocTest.pass"),
            getWorkDir()
        );
    }
    
    public void testChangeJavaDocText() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            ((Feature) clazz.getContents().get(1)).setJavadocText("Javadoc to be changed.\nTwo line comment.");
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/JavaDocTestClass.java"),
            getGoldenFile("testChangeJavaDocText_JavaDocTest.pass"),
            getWorkDir()
        );
    }
    
    public void testAddJavaDocText2() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            clazz.setJavadocText("This is TestFile\n@author NoBody");
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/JavaDocTestClass.java"),
            getGoldenFile("testAddJavaDocText2_JavaDocTest.pass"),
            getWorkDir()
        );
    }
    
    public void testRemoveJavaDocText() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            clazz.setJavadocText(null);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/JavaDocTestClass.java"),
            getGoldenFile("testRemoveJavaDocText_JavaDocTest.pass"),
            getWorkDir()
        );
    }
    
    public void testAddJavaDocText3() throws IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            clazz.setJavadocText("This is TestFile\n@author NoBody");
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/JavaDocTestClass.java"),
            getGoldenFile("testAddJavaDocText2_JavaDocTest.pass"),
            getWorkDir()
        );
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
