/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.FieldGroup;
import org.netbeans.jmi.javamodel.ForStatement;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodClass;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.OperatorEnum;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.UnaryExpression;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author  Pavel Flaska
 */
public class GroupTest extends NbTestCase {
    
    /** Need to be defined because of JUnit */
    public GroupTest() {
        super("GroupTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(GroupTest.class);
        return suite;
    }
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.GroupTestClass");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    /**
     * Tests the field groups.
     */
    public void testGroup() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            int i = 0;
            for (Iterator fIt = clazz.getContents().iterator(); fIt.hasNext(); ) {
                i++;
                FieldGroup fieldGroup = (FieldGroup) fIt.next();
                Field fieldToRemove = null;
                for (Iterator fieldsIt = fieldGroup.getFields().iterator(); fieldsIt.hasNext(); ) {
                    Field f = (Field) fieldsIt.next();
                    String fieldName = f.getName();
                    if ("b".equals(fieldName)) {
                        f.setName("bingo");
                    } else if ("sun".equals(fieldName)) {
                        f.setInitialValueText("\"does not have notebooks!\"");
                    } else if ("ibm".equals(fieldName)) {
                        f.setInitialValueText("\"Thinkpad\"");
                    } else if ("coca".equals(fieldName)) {
                        fieldToRemove = f;
                    } else if ("rc".equals(fieldName)) {
                        f.setInitialValueText(null);
                    }
                }
                fieldGroup.getFields().remove(fieldToRemove);
            }
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/GroupTestClass.java"),
            getGoldenFile("GroupTestClass.pass"),
            getWorkDir()
        );
    }

    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
