/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 * Tests more transaction on file with fields. Tests fields generating and
 * also update.
 *
 * @author  Pavel Flaska
 */
public class FieldTest3 extends NbTestCase {
    
    /** Creates a new instance of FieldTest3 */
    public FieldTest3() {
        super("FieldTest3");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(FieldTest3.class);
        return suite;
    }
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.FieldTest3");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    /**
     * Tests inital value for fields in field group.
     */
    public void testGroupInitValues() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            FieldGroup group = (FieldGroup) clazz.getContents().get(2);
            List fields = group.getFields();
            ((Field) fields.get(0)).setInitialValueText("\"prvni\"");
            ((Field) fields.get(2)).setInitialValueText("\"treti\"");
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/FieldTest3.java"),
            getGoldenFile("testGroupInitValues_FieldTest3.pass"),
            getWorkDir()
        );
    }
    
    /**
     * Tests group separation
     */
    public void testGroupSeparation() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Field second = (Field) clazz.getFeatures().remove(3);
            Field third = (Field) clazz.getFeatures().remove(3);
            clazz.getFeatures().add(second);
            clazz.getFeatures().add(third);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/FieldTest3.java"),
            getGoldenFile("testGroupSeparation_FieldTest3.pass"),
            getWorkDir()
        );
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
