/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen.FieldTest1;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.jmi.javamodel.codegen.CodegenTestCase;
import org.netbeans.jmi.javamodel.codegen.Utility;
import org.netbeans.junit.NbTestSuite;

/**
 * Test the field generator.
 *
 * @author  Pavel Flaska
 */
public class FieldTest1 extends CodegenTestCase {
    
    /** Need to be defined because of JUnit */
    public FieldTest1(String name) {
        super(name, "FieldTest1");
    }

    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTest(new FieldTest1("testFieldModifiers"));
        suite.addTest(new FieldTest1("testFieldType"));
        suite.addTest(new FieldTest1("testFieldName"));
        suite.addTest(new FieldTest1("testFieldInitialValueText"));
        suite.addTest(new FieldTest1("testFieldInitialValue"));
        suite.addTest(new FieldTest1("testFieldChangeInInitValue"));
        suite.addTest(new FieldTest1("testFieldInitialValueRemoval"));
        return suite;
    }
    
    JavaClass clazz;
    JavaModelPackage pkg;
    Field[] field = new Field[7];
    
    protected void setUp() {
        clazz = Utility.findClass("org.netbeans.test.codegen.FieldTest1");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
        // initialize methods
        int i = 0;
        for (Iterator mIt = clazz.getFeatures().iterator(); mIt.hasNext(); i++) {
            field[i] = (Field) mIt.next();
        }
    }

    /**
     * Removes all the modififers from the field.
     */
    public void testFieldModifiers() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            int modifiers = field[0].getModifiers();
            modifiers &= ~(Modifier.PRIVATE | Modifier.FINAL | Modifier.STATIC);
            field[0].setModifiers(modifiers);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        makeDiff("testFieldModifiers");
    }
    
    /**
     * Changes long type of the field to short type.
     */
    public void testFieldType() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            field[1].setTypeName(pkg.getMultipartId().createMultipartId("short", null, null));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        makeDiff("testFieldType");
    }
    
    /**
     * Changes field name to thisIsTheNewName.
     */
    public void testFieldName() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            field[2].setName("thisIsTheNewName");
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        makeDiff("testFieldName");
    }
    
    /**
     * Changes the initial value text.
     */
    public void testFieldInitialValueText() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            field[3].setInitialValueText("\"This is a new text.\"");
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        makeDiff("testFieldInitialValueText");
    }
    
    /**
     * Change whole initial value expression to literal 78.
     */
    public void testFieldInitialValue() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Literal l = pkg.getLongLiteral().createLongLiteral((long) 78);
            field[4].setInitialValue(l);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        makeDiff("testFieldInitialValue");
    }
    
    /**
     * Changes the initialization 'new String("NetBeers")' to 'new String()'.
     * It tests only change in expression, no expression swap.
     */
    public void testFieldChangeInInitValue() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            NewClassExpression nce = (NewClassExpression) field[5].getInitialValue();
            List parameters = nce.getParameters();
            Object o = parameters.remove(0);
            parameters.add(pkg.getStringLiteral().createStringLiteral("NetBeans"));
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        makeDiff("testFieldChangeInInitValue");
    }

    /**
     * Removes the inital value from the field.
     */
    public void testFieldInitialValueRemoval() {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            field[6].setInitialValue(null);
            fail = false;
        }
        finally  {
            Utility.endTrans(fail);
        }
        makeDiff("testFieldInitialValueRemoval");
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
