/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author  Martin Matula
 */
public class EnumTest extends NbTestCase {
    
    public EnumTest() {
        super("EnumTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(EnumTest.class);
        return suite;
    }
    
    JavaEnum clazz;
    JavaModelPackage pkg;
    
    protected void setUp() {
        clazz = (JavaEnum) Utility.findClass("org.netbeans.test.codegen.EnumTest");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    public void testAddConstant() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            EnumConstant literal = pkg.getEnumConstant().createEnumConstant("LITERAL4", null, 0, null, null, false, null, 0, null, null, null);
            clazz.getConstants().add(literal);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/EnumTest.java"),
            getGoldenFile("EnumTest.pass"),
            getWorkDir()
        );
    }

    public void testNewEnum() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            JavaEnum javaEnum = pkg.getJavaEnum().createJavaEnum(
                "InnerEnum",     // name
                null,            // annotations
                Modifier.PUBLIC, // modifiers
                null,            // javadocText
                null,            // javadoc
                null,            // contents
                null,            // superClassName 
                null,            // interfaceNames 
                null,            // typeParameters 
                null             // constants 
            );
            EnumConstant literal = pkg.getEnumConstant().createEnumConstant(
                "FIRST_CONSTANT",
                null,
                0,
                null,
                null,
                false,
                null,
                0,
                null,
                null,
                null
            );
            clazz.getContents().add(javaEnum);
            javaEnum.getConstants().add(literal);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/EnumTest.java"),
            getGoldenFile("testNewEnum_EnumTest.pass"),
            getWorkDir()
        );
    }
    
    public void testNewEmptyEnum() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            JavaEnum javaEnum = pkg.getJavaEnum().createJavaEnum(
                "InnerOriginallyEmptyEnum",     // name
                null,            // annotations
                Modifier.PUBLIC, // modifiers
                null,            // javadocText
                null,            // javadoc
                null,            // contents
                null,            // superClassName 
                null,            // interfaceNames 
                null,            // typeParameters 
                null             // constants 
            );
            clazz.getContents().add(javaEnum);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/EnumTest.java"),
            getGoldenFile("testNewEmptyEnum_EnumTest.pass"),
            getWorkDir()
        );
    }

    public void testAddConstantToEmptyEnum() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            JavaEnum javaEnum = (JavaEnum) clazz.getContents().get(1);
            EnumConstant literal = pkg.getEnumConstant().createEnumConstant(
                null,
                null,
                0,
                null,
                null,
                false,
                null,
                0,
                null,
                null,
                null
            );
            literal.setName("TO_NEW_ENUM_CONSTANT");
            javaEnum.getConstants().add(literal);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/EnumTest.java"),
            getGoldenFile("testAddConstantToEmptyEnum_EnumTest.pass"),
            getWorkDir()
        );
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
}
