/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.jmiimpl.javamodel.AttributeImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author  Pavel Flaska
 */
public class AnnotationTypeTest extends NbTestCase {
    
    AnnotationType clazz;
    JavaModelPackage pkg;
    
    /** Creates a new instance of AnnotationTypeTest */
    public AnnotationTypeTest() {
        super("AnnotationTypeTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(AnnotationTypeTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (AnnotationType) Utility.findClass("org.netbeans.test.codegen.AnnotationType");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }

    public void testAddAttribute() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            getLog().println("Annotation type '" + clazz.getName() + "' has following attributes:");
            for (Iterator it = clazz.getContents().iterator(); it.hasNext(); ) {
                AttributeImpl attr = (AttributeImpl) it.next();
                getLog().println("\tAttribute named '" + attr.getName() +
                    "' with type '" + attr.getTypeName().getName() + 
                    "' has default value '" + attr.getDefaultValueText() + "'.");
            }
            Attribute newAttr = pkg.getAttribute().createAttribute(
                "newAttribute", // name
                null, // annotations
                0,    // modifiers
                null, // javadocText
                null, // javadoc
                pkg.getMultipartId().createMultipartId("String", null, null), // typeName
                pkg.getMultipartId().createMultipartId("\"Letadlo\"", null, null), // defaultValue
                null  // default value text
            );
            clazz.getFeatures().add(newAttr);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnotationType.java"),
            getGoldenFile("testAddAttribute_AnnotationType.pass"),
            getWorkDir()
        );
    }
    
    public void testRemoveAttribute() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            clazz.getFeatures().remove(1);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnotationType.java"),
            getGoldenFile("testRemoveAttribute_AnnotationType.pass"),
            getWorkDir()
        );
    }
    
    public void testAttributeTypeChange() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Attribute attr = (Attribute) clazz.getFeatures().get(0);
            attr.setTypeName(pkg.getMultipartId().createMultipartId("long", null, null));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnotationType.java"),
            getGoldenFile("testAttributeTypeChange_AnnotationType.pass"),
            getWorkDir()
        );
    }
    
    public void testAttributeNameChange() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Attribute attr = (Attribute) clazz.getFeatures().get(0);
            attr.setName("newId");
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnotationType.java"),
            getGoldenFile("testAttributeNameChange_AnnotationType.pass"),
            getWorkDir()
        );
    }
    
    public void testAttributeDefaultValueChange() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Attribute attr = (Attribute) clazz.getFeatures().get(0);
            attr.setDefaultValueText("666");
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnotationType.java"),
            getGoldenFile("testAttributeDefaultValueChange_AnnotationType.pass"),
            getWorkDir()
        );
    }
    
    public void testAttributeDefaultValue2Change() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Attribute attr = (Attribute) clazz.getFeatures().get(1);
            attr.setDefaultValue(pkg.getMultipartId().createMultipartId("\"MaM\"", null, null));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnotationType.java"),
            getGoldenFile("testAttributeDefaultValue2Change_AnnotationType.pass"),
            getWorkDir()
        );
    }
    
    public void testAttributeDefaultValue3Change() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Attribute attr = (Attribute) clazz.getFeatures().get(3);
            attr.setDefaultValue(pkg.getMultipartId().createMultipartId("\"das Flugzeug\"", null, null));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnotationType.java"),
            getGoldenFile("testAttributeDefaultValue3Change_AnnotationType.pass"),
            getWorkDir()
        );
    }
 
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
}
