/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author  Pavel Flaska
 */
public class AnnotationTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    /** Creates a new instance of AnnotationTest */
    public AnnotationTest() {
        super("AnnotationTest");
    }

    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(AnnotationTest.class);
        return suite;
    }

    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.codegen.AnnotationClass");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    public void testAddAnnotation() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Method method = (Method) clazz.getContents().get(0);
            // log the annotation information
            getLog().println("Method '" + method.getName() + "' has following annotations:");
            for (Iterator it = method.getAnnotations().iterator(); it.hasNext(); ) {
                Annotation annotation = (Annotation) it.next();
                getLog().println("\tAnnotation named '" + annotation.getType().getName() + "'.");
                for (Iterator it2 = annotation.getAttributeValues().iterator(); it2.hasNext(); ) {
                    AttributeValue attribute = (AttributeValue) it2.next();
                    getLog().println("\t\tAttribute value '" + attribute.getName() + "', '" + ((MetadataElement) attribute.getValue()).getSourceText() + "'.");
                }
            }
            Annotation ann = createSimpleAnn("\"2004-06-21\"", "\"Lojza\"", "\"Unknown\"", "46");
            method = (Method) clazz.getContents().get(1);
            method.getAnnotations().add(ann);
            fail = false;
       }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnotationClass.java"),
            getGoldenFile("testAddAnnotation_AnnotationClass.pass"),
            getWorkDir()
        );
    }
    
    public void testAddAnnWithField() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Annotation ann = createSimpleAnn("\"2004-07-21\"", "\"Karlik\"", "\"Neznamy\"", "12");
            Field f = pkg.getField().createField(
                "newField",
                Collections.singletonList(ann),
                0,
                "Neue",
                null,
                false,
                pkg.getMultipartId().createMultipartId("String", null, null),
                0, 
                null,
                "\"novy field\""
            );
            clazz.getContents().add(0, f);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnotationClass.java"),
            getGoldenFile("testAddAnnWithField_AnnotationClass.pass"),
            getWorkDir()
        );
    }

    public void testAddAnnWithConstr() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Annotation ann = createSimpleAnn("\"2004-07-22\"", "\"Davidek\"", "\"inedit\"", "666");
            Constructor constructor = pkg.getConstructor().createConstructor(
                null,
                Collections.singletonList(ann),
                Modifier.PUBLIC,
                "Added constructor",
                null,
                null,
                "// nothing",
                null,
                null,
                null
            );
            clazz.getContents().add(1, constructor);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnotationClass.java"),
            getGoldenFile("testAddAnnWithConstr_AnnotationClass.pass"),
            getWorkDir()
        );
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
    private Annotation createSimpleAnn(String attr1, String attr2, String attr3, String attr4) {
        MultipartIdClass multiProxy = pkg.getMultipartId();
        Annotation ann = pkg.getAnnotation().createAnnotation();
        ann.setTypeName(multiProxy.createMultipartId("AnnotationType", null, null));
        List attrList = new ArrayList();
        AttributeValueClass avProxy = pkg.getAttributeValue();
        attrList.add(avProxy.createAttributeValue("date", multiProxy.createMultipartId(attr1, null, null)));
        attrList.add(avProxy.createAttributeValue("engineer", multiProxy.createMultipartId(attr2, null, null)));
        attrList.add(avProxy.createAttributeValue("synopsis", multiProxy.createMultipartId(attr3, null, null)));
        attrList.add(avProxy.createAttributeValue("id", multiProxy.createMultipartId(attr4, null, null)));
        ann.getAttributeValues().addAll(attrList);
        return ann;
    }
}
