/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.AttributeValueClass;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.EmptyStatement;
import org.netbeans.jmi.javamodel.IntLiteral;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 * Tests related to generating annotation on method/constructor parameter.
 *
 * @author Pavel Flaska
 */
public class AnnotationOnParamTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    /** Creates a new instance of AnnotationOnParamTest */
    public AnnotationOnParamTest() {
        super("AnnotationOnParamTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(AnnotationOnParamTest.class);
        return suite;
    }

    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.codegen.AnnOnParam");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    public void testAnnOnPar1() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            CallableFeature cf = (CallableFeature) clazz.getFeatures().get(0);
            Object o = ((Parameter) cf.getParameters().get(0)).getAnnotations().remove(0);
            getLog().println(o);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnOnParam.java"),
            getGoldenFile("testAnnOnPar1_AnnOnParam.pass"),
            getWorkDir()
        );
    }
    
    public void testAnnOnPar2() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            CallableFeature cf = (CallableFeature) clazz.getFeatures().get(1);
            ((Parameter) cf.getParameters().get(0)).setFinal(false);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnOnParam.java"),
            getGoldenFile("testAnnOnPar2_AnnOnParam.pass"),
            getWorkDir()
        );
    }
    
    public void testAnnOnPar3() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            CallableFeature cf = (CallableFeature) clazz.getFeatures().get(2);
            Annotation ann = (Annotation) ((Parameter) cf.getParameters().get(0)).getAnnotations().get(0);
            ((AttributeValue) ann.getAttributeValues().get(0)).setValue(pkg.getIntLiteral().createIntLiteral(11));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnOnParam.java"),
            getGoldenFile("testAnnOnPar3_AnnOnParam.pass"),
            getWorkDir()
        );
    }
    
    public void testAnnOnPar4() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            CallableFeature cf = (CallableFeature) clazz.getFeatures().get(3);
            List l = ((Parameter) cf.getParameters().get(0)).getAnnotations();
            l.add(pkg.getAnnotation().createAnnotation(pkg.getMultipartId().createMultipartId("Deprecated", null, null), null));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnOnParam.java"),
            getGoldenFile("testAnnOnPar4_AnnOnParam.pass"),
            getWorkDir()
        );
    }

    public void testAnnOnPar11() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            CallableFeature cf = (CallableFeature) clazz.getFeatures().get(0);
            ((Parameter) cf.getParameters().get(0)).setFinal(true);
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnOnParam.java"),
            getGoldenFile("testAnnOnPar11_AnnOnParam.pass"),
            getWorkDir()
        );
    }
    
    public void testAddFeatureWithAnnOnPar()  throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            EmptyStatement es = pkg.getEmptyStatement().createEmptyStatement();
            MultipartId mid = pkg.getMultipartId().createMultipartId("String", null, Collections.EMPTY_LIST);
            List pl = new ArrayList(2);
            pl.add(pkg.getParameter().createParameter("aName", null, false, mid, 0, false));
            List attrs = new ArrayList(4);
            AttributeValueClass avc = pkg.getAttributeValue();
            IntLiteral id = pkg.getIntLiteral().createIntLiteral(666);
            StringLiteral enginner = pkg.getStringLiteral().createStringLiteral("Dan");
            StringLiteral synopsis = pkg.getStringLiteral().createStringLiteral("Test");
            StringLiteral date = pkg.getStringLiteral().createStringLiteral("2005-03-30");
            attrs.add(avc.createAttributeValue("id", id));
            attrs.add(avc.createAttributeValue("date", date));
            attrs.add(avc.createAttributeValue("engineer", enginner));
            attrs.add(avc.createAttributeValue("synopsis", synopsis));
            Annotation a = pkg.getAnnotation().createAnnotation(pkg.getMultipartId().createMultipartId("AnnotationType", null, null), attrs);
            MultipartId mid2 = pkg.getMultipartId().createMultipartId("java.util.List", null, Collections.EMPTY_LIST);
            pl.add(pkg.getParameter().createParameter("aList", Collections.singletonList(a), true, mid2, 0, false));
            clazz.getContents().add(pkg.getConstructor().createConstructor(null, Collections.EMPTY_LIST, Modifier.PUBLIC, null, null, null, "", null, pl, null));
            fail = false;
        }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnOnParam.java"),
            getGoldenFile("testAddFeatureWithAnnOnPar_AnnOnParam.pass"),
            getWorkDir()
        );
    }
}
