/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValueClass;
import org.netbeans.jmi.javamodel.BehavioralFeature;
import org.netbeans.jmi.javamodel.IntLiteral;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author Pavel Flaska
 */
public class AnnotationOnLocVarTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    /** Creates a new instance of AnnotationAttributeValueTest */
    public AnnotationOnLocVarTest() {
        super("AnnotationOnLocVarTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(AnnotationOnLocVarTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.codegen.AnnOnLocalVar");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    public void testAddAnnToLocVar() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            StatementBlock sb = ((BehavioralFeature) clazz.getContents().get(0)).getBody();
            List l = sb.getStatements();
            LocalVarDeclaration lvd = (LocalVarDeclaration) l.get(0);
            LocalVariable lv = (LocalVariable) lvd.getVariables().get(0);
            List attrs = new ArrayList(4);
            AttributeValueClass avc = pkg.getAttributeValue();
            IntLiteral id = pkg.getIntLiteral().createIntLiteral(666);
            StringLiteral enginner = pkg.getStringLiteral().createStringLiteral("PaF");
            StringLiteral synopsis = pkg.getStringLiteral().createStringLiteral("fat");
            StringLiteral date = pkg.getStringLiteral().createStringLiteral("2005");
            attrs.add(avc.createAttributeValue("id", id));
            attrs.add(avc.createAttributeValue("synopsis", synopsis));
            attrs.add(avc.createAttributeValue("engineer", enginner));
            attrs.add(avc.createAttributeValue("date", date));
            Annotation a = pkg.getAnnotation().createAnnotation(pkg.getMultipartId().createMultipartId("AnnotationType", null, null), attrs);
            lv.getAnnotations().add(a);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnOnLocalVar.java"),
            getGoldenFile("testAddAnnToLocVar_AnnotationOnLocVarTest.pass"),
            getWorkDir()
        );
    }
    
    public void testAddLocVarWithAnn() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            StatementBlock sb = ((BehavioralFeature) clazz.getContents().get(0)).getBody();
            List l = sb.getStatements();
            List attrs = new ArrayList(4);
            AttributeValueClass avc = pkg.getAttributeValue();
            IntLiteral id = pkg.getIntLiteral().createIntLiteral(777);
            StringLiteral enginner = pkg.getStringLiteral().createStringLiteral("Snoopy");
            StringLiteral synopsis = pkg.getStringLiteral().createStringLiteral("thin");
            StringLiteral date = pkg.getStringLiteral().createStringLiteral("2001");
            attrs.add(avc.createAttributeValue("id", id));
            attrs.add(avc.createAttributeValue("synopsis", synopsis));
            attrs.add(avc.createAttributeValue("engineer", enginner));
            attrs.add(avc.createAttributeValue("date", date));
            Annotation a = pkg.getAnnotation().createAnnotation(pkg.getMultipartId().createMultipartId("AnnotationType", null, null), attrs);
            MultipartId id1 = pkg.getMultipartId().createMultipartId("java.util.List", null, null);
            LocalVariable lv = (LocalVariable) pkg.getLocalVariable().createLocalVariable("testVar", null /* annotations here are not supported in 4.1 */, true, id1, 0, null, "new java.util.ArrayList(3)");
            LocalVarDeclaration lvd = (LocalVarDeclaration) pkg.getLocalVarDeclaration().createLocalVarDeclaration(true, (MultipartId) id1.duplicate(), Collections.singletonList(lv));
            lv.getAnnotations().add(a);
            l.add(0, lvd);
            fail = false;
        } finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnOnLocalVar.java"),
            getGoldenFile("testAddLocVarWithAnn_AnnotationOnLocVarTest.pass"),
            getWorkDir()
        );
    }
}
