/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmi.javamodel.codegen;

import java.util.Iterator;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.openide.filesystems.FileStateInvalidException;

/**
 * Tests the annotation attribute value change, i.e. changes in 'id', 'synopsis'
 * in the following example:
 * <code>
 * @RequestForEnhancement(id = 333, synopsis = "implement") public abstract void foo();
 * @Copyright("John Smith") public abstract void foo(); 
 * </code>
 *
 * @author Pavel Flaska
 */
public class AnnotationAttributeValueTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    
    /** Creates a new instance of AnnotationAttributeValueTest */
    public AnnotationAttributeValueTest() {
        super("AnnotationAttributeValueTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(AnnotationAttributeValueTest.class);
        return suite;
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.codegen.AnnotationAttributeValueTest");
        pkg = (JavaModelPackage) clazz.refImmediatePackage();
    }
    
    public void testChangeAttributeName() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Constructor constructor = (Constructor) clazz.getContents().get(0);
            // log the annotation information
            getLog().println("Constructor has following annotations:");
            for (Iterator it = constructor.getAnnotations().iterator(); it.hasNext(); ) {
                Annotation annotation = (Annotation) it.next();
                getLog().println("\tAnnotation named '" + annotation.getType().getName() + "'.");
                for (Iterator it2 = annotation.getAttributeValues().iterator(); it2.hasNext(); ) {
                    AttributeValue attribute = (AttributeValue) it2.next();
                    getLog().println("\t\tAttribute value '" + attribute.getName() + "', '" + ((MetadataElement) attribute.getValue()).getSourceText() + "'.");
                    String newName = attribute.getName() + "_2";
                    attribute.setName(newName);
                    getLog().println("\t\tChanging its name to '" + newName + "'.");
                }
            }
            fail = false;
       }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnotationAttributeValueTest.java"),
            getGoldenFile("testChangeAttributeName_AnnotationAttributeValueTest.pass"),
            getWorkDir()
        );
    }
    
    public void testChangeAttributeValue() throws java.io.IOException, FileStateInvalidException {
        boolean fail = true;
        Utility.beginTrans(true);
        try {
            Constructor constructor = (Constructor) clazz.getContents().get(0);
            // log the annotation information
            getLog().println("Constructor has following annotations:");
            for (Iterator it = constructor.getAnnotations().iterator(); it.hasNext(); ) {
                Annotation annotation = (Annotation) it.next();
                getLog().println("\tAnnotation named '" + annotation.getType().getName() + "'.");
                AttributeValue attribute = (AttributeValue) annotation.getAttributeValues().get(1);
                getLog().println("\t\tAttribute value '" + attribute.getName() + "', '" + ((MetadataElement) attribute.getValue()).getSourceText() + "'.");
                StringLiteral sl = pkg.getStringLiteral().createStringLiteral("PaF");
                attribute.setValue(sl);
                getLog().println("\t\tChanging its value to PaF");
            }
            fail = false;
       }
        finally {
            Utility.endTrans(fail);
        }
        assertFile("File is not correctly generated.",
            Utility.getFile(getDataDir(), "org/netbeans/test/codegen/AnnotationAttributeValueTest.java"),
            getGoldenFile("testChangeAttributeValue_AnnotationAttributeValueTest.pass"),
            getWorkDir()
        );
    }
}
