/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.javacore.scanning;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
/**
 *
 * @author  thurka
 */
class ZipArchiveInfo {
    ZipFile zipFile;
    String offset;
    Map directoryMap=new HashMap(1000);
    ZipDirInfo rootInfo;
    
    /** Creates a new instance of ZipArchiveInfo */
    ZipArchiveInfo(File f, String offset) throws IOException {
        zipFile=new ZipFile(f);
        this.offset = offset;
        rootInfo=new ZipDirInfo("",""); // NOI18N
    }
    
    void close() throws IOException {
        if (zipFile != null) zipFile.close();
    }
    
    FileInfo getRootFileInfo() {
        Enumeration en=zipFile.entries();
        
        while(en.hasMoreElements()) {
            ZipEntry entry=(ZipEntry)en.nextElement();
            if (!entry.isDirectory()) {
                String name=entry.getName();
                if (offset != null) {
                    if (name.startsWith(offset)) {
                        name = name.substring(offset.length());
                    }
                    else {
                        continue;
                    }
                }
                int lastSlashIndex = name.lastIndexOf('/');
                String directoryName="";
                String shortName=name;
                
                if (lastSlashIndex > -1) {
                    directoryName=name.substring(0, lastSlashIndex);
                    shortName=name.substring(lastSlashIndex+1);
                }
                getDirectory(directoryName).addEntry(zipFile,entry,shortName,name);
            }
        }
        return rootInfo;
    }
    
    private ZipDirInfo getDirectory(String dirName) {
        ZipDirInfo zipDir=(ZipDirInfo)directoryMap.get(dirName);
        
        if (zipDir==null){
            ZipDirInfo parentInfo;
            int lastSlashIndex = dirName.lastIndexOf('/');
            String shortName=dirName;
            if (lastSlashIndex > -1) {
                String parentDirName = dirName.substring(0, lastSlashIndex);
                shortName=dirName.substring(lastSlashIndex+1);
                parentInfo=getDirectory(parentDirName);
            } else {
                parentInfo=rootInfo;
            }
            zipDir=new ZipDirInfo(dirName,shortName);
            parentInfo.addDir(zipDir);
            directoryMap.put(dirName,zipDir);
        }
        return zipDir;
    }    
}
