/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.scanning;

import java.io.IOException;
import java.io.InputStream;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/**
 *
 * @author  thurka
 */
class FObjectInfo implements FileInfo {
    FileObject fo;
    
    FObjectInfo(FileObject f) {
        fo=f;
    }

    public InputStream getInputStream() throws IOException {
        return fo.getInputStream();
    }

    public String getName() {
        return fo.getNameExt();
    }

    public String getPath() {
        throw new UnsupportedOperationException();        
    }

    public boolean isDirectory() {
        return false;
    }

    public long lastModified() {
        return fo.lastModified().getTime();
    }

    public FileInfo[] listFiles() {
        return EMPTY_ARR;
    }
    
    public String getCanonicalName() {
        try {
            return FileUtil.toFile(fo).getCanonicalPath();
        } catch (Exception ex) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, ex);
            return getName();
        }
    }
}
