/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.javacore.JMManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;

/**
 *
 * @author  sdedic
 * @version 
 */
public class Util {
    static final String ATTR_FILE_ENCODING = "Content-Encoding"; // NOI18N
    
    /** Retrieves file's encoding. Returns the default encoding for java files,
     * if the file's specific encoding is not set.
     * Disclaimer: this method is <B>not an API method</B>. It may not
     * be available in future releases.
     * @param someFile file object to retrieve encoding for
     * @return encoding string, or null if no explicit encoding is given in file's
     * or IDE's settings.
     *
     */
    public static String getFileEncoding(FileObject someFile) {
        String enc = (String) someFile.getAttribute(ATTR_FILE_ENCODING);

        if (enc == null) {
            enc = JMManager.getDefaultEncoding();
        }
        if ("".equals(enc))
            return null;
        else
            return enc;
    }
    
    public static String readContents(Reader r, long size) throws IOException {
        assert size<Integer.MAX_VALUE;
        char buffer[] = new char[(int)size];
        int offset = 0;
        while (offset < buffer.length) {
            long read = r.read(buffer, offset, buffer.length - offset);
            if (read == -1) break;
            offset += read;
        }
        return new String(buffer,0,offset);
    }
    
    
    /**
     * Method that allows to find its
     * CloneableEditorSupport from given DataObject
     * @return the support or null if the CloneableEditorSupport 
     * was not found
     * This method is hot fix for issue #53309
     * this methd was copy/pasted from OpenSupport.Env class
     * @param dob an instance of DataObject
     */
    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dob) {
        Object obj = dob.getCookie(CloneableEditorSupport.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getCookie(org.openide.cookies.OpenCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getCookie(org.openide.cookies.EditorCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        return null;
    }

    public static boolean isModified(FileObject fo) {
        return getModifiedDataObject(fo)!=null;
    }
    
    public static DataObject getModifiedDataObject(FileObject fo) {
        DataObject[] dobjs = DataObject.getRegistry().getModified();
        for (int i = 0; i < dobjs.length; i++) {
            FileObject fobj = dobjs[i].getPrimaryFile();
            if (fobj != null && fobj.isValid() && fobj.equals(fo)) {
                return dobjs[i];
            }
        }
        JMManager.ModifiedDOProvider p = JMManager.ModifiedDOProvider.getModifiedDOProvider();
        if (p != null) {
            return p.getModifiedDataObject(fo);
        }
        return null;
    }    
}
