/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;

/**
 * @author Tomas Hurka
 * @author Pavel Flaska
 */
public final class TypeParamInfo extends ElementInfo {
    public static final int TYPEPARAM_TYPE = ASTreeTypes.TYPE_PARAMETER;
    public final TypeParamRef[] bounds;

    private SemiPersistentElement owner = null;

    public TypeParamInfo(ASTree tree, int infoType, String name, TypeParamRef[] bounds) {
        super(tree, infoType, name);
        this.bounds = bounds == null ? EMPTY_TPREFS : bounds;
    }

    private ASTree[] getBoundsAST(SemiPersistentElement owner) {
        ASTree bndAST;
        ASTree tree = owner.getASTree();
        if (tree != null) {
            bndAST = tree.getSubTrees()[1];
        } else {
            bndAST = null;
        }
        return MetadataElement.getChildNodes(bndAST, ASTreeTypes.BOUND_LIST);
    }
}
