/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

/**
 *
 * @author  Tomas Hurka
 */
public class StringMeasure implements Measure {
    public static final StringMeasure INSTANCE = new StringMeasure();
    private static final int SAME=0;
    private static final int CASE_SAME=1;
    private static final int DIFFERENT=10;
    
    private StringMeasure() {
    }
    
    /** this method implements metrics on Strings.
     * @param x first string
     * @param y second string
     * @return returns int value between 0 and 100.
     * Where 0 means the strings are
     * identical, 100 strings are completly
     * different.
     */
    public final int getDistance(final Object first, final Object second) {
        if (first==second)
            return 0;
        if (first==null || second==null)
            return INFINITE_DISTANCE;
        final String x=(String)first;
        final String y=(String)second;
        final int xlen=x.length();
        final int ylen=y.length();
        int errors=0;
        int xindex=0,yindex=0;
        final char xarr[]=new char[xlen+1];
        final char yarr[]=new char[ylen+1];
        
        x.getChars(0, xlen, xarr, 0);
        y.getChars(0, ylen, yarr, 0);
        while(xindex<xlen && yindex<ylen){
            final char xchar=xarr[xindex];
            final char ychar=yarr[yindex];
            final int cherr=compareChars(xchar,ychar);
            
            if (cherr!=DIFFERENT) {
                errors+=cherr;
                xindex++;
                yindex++;
                continue;
            }
            final char xchar1=xarr[xindex+1];
            final char ychar1=yarr[yindex+1];
            if (xchar1!=0 && ychar1!=0) {
                final int cherr1=compareChars(xchar1,ychar1);
                
                if (cherr1!=DIFFERENT) {
                    errors+=DIFFERENT+cherr1;
                    xindex+=2;
                    yindex+=2;
                    continue;
                }
                final int xerr=compareChars(xchar,ychar1);
                final int xerr1=compareChars(xchar1,ychar);
                
                if (xerr!=DIFFERENT && xerr1!=DIFFERENT) {
                    errors+=DIFFERENT+xerr+xerr1;
                    xindex+=2;
                    yindex+=2;
                    continue;
                }
            }
            if (xlen-xindex>ylen-yindex) {
                xindex++;
            } else if (xlen-xindex<ylen-yindex) {
                yindex++;
            } else {
                xindex++;
                yindex++;
            }
            errors+=DIFFERENT;
        }
        errors+=(xlen-xindex+ylen-yindex)*DIFFERENT;
        return (INFINITE_DISTANCE*errors)/Math.max(ylen,xlen)/DIFFERENT;
    }
    
    private static final int compareChars(final char xc,final char yc) {
        if (xc==yc)
            return SAME;
        char xlower = Character.toLowerCase(xc);
        char ylower = Character.toLowerCase(yc);
        if (xlower==ylower) {
            return CASE_SAME;
        }
        return DIFFERENT;
    }
}
