/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.parser;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;

/**
 *
 * @author  Tomas Hurka
 */
public class StaticImportScope  implements ScopeMember {
    private JavaClass javaClass;
    private Map features;
    private String name;
    
    StaticImportScope(JavaClass jcls,String n) {
        javaClass=jcls;
        name=n;
    }
    
    private void initFeatureMap() {
        Object[] featureArr=javaClass.getFeatures().toArray();
        
        features=new HashMap();
        for (int i=0;i<featureArr.length;i++) {
            ClassMember feature=(ClassMember)featureArr[i];
            int modifiers=feature.getModifiers();
            String fname;
            
            if (!Modifier.isStatic(modifiers)) 
                continue;
            fname=feature.getName();
            if (name!=null && !name.equals(fname))
                continue;
            if (feature instanceof Field) {                
                features.put(fname, feature);
            }
            else if (feature instanceof Method) {
                features.put(fname.concat("("),javaClass.getName()); // NOI18N
            }
        }
        javaClass=null;
    }
    
    public Object lookup(Object key) {
        if (features==null)
            initFeatureMap();
        return features.get(key);
    }
}
