/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

/**
 *
 * @author  Martin Matula
 */
class OrderedArrayMeasure implements Measure {
    private final Measure measure;
    
    OrderedArrayMeasure(Measure elementsMeasure) {
        measure = elementsMeasure;
    }
    
    public int getDistance(Object first, Object second) {
        Object[] array1 = (Object[]) first;
        Object[] array2 = (Object[]) second;
        int minSize = Math.min(array1.length, array2.length);
        int difference = Math.abs(array1.length-array2.length);
        int result = 0;
        
        if (minSize==0) {
            if (difference!=0)
                result=INFINITE_DISTANCE;
            return result;
        }
        for (int i = 0; i < minSize; i++) {
            result += measure.getDistance(array1[i], array2[i]);
        }
        result += difference * INFINITE_DISTANCE;
        result /= (minSize+difference);
        return result > INFINITE_DISTANCE ? INFINITE_DISTANCE : result;
    }
}
