/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.util.IOUtils;
import org.openide.util.Utilities;

public class NameRef extends TypeParamRef {
    public final TypeParamRef parent;
    public final TypeRef[] args;

    public static final NameRef java_lang_Object = new NameRef("java.lang.Object"); // NOI18N
    public static final NameRef java_lang_Enum = new NameRef("java.lang.Enum"); // NOI18N
    public static final NameRef java_lang_Annotation = new NameRef("java.lang.annotation.Annotation"); // NOI18N
    
    private int hashCode;

    public static Object read(InputStream stream, StorableBaseObject storable) throws IOException {
        TypeParamRef parent = (TypeParamRef) IOUtils.read(stream, storable);
        int len = IOUtils.readInt(stream);
        TypeRef[] args;
        if (len == 0) {
            args = ElementInfo.EMPTY_TYPEREFS;
        } else {
            args = new TypeRef[len];
        }
        for (int i = 0; i < args.length; i++) {
            args[i] = (TypeRef) IOUtils.read(stream, storable);
        }
        return new NameRef(stream, parent, args);
    }
    
    public void write(OutputStream outputStream, StorableBaseObject storable) throws IOException {
        IOUtils.write(outputStream, parent, storable);
        IOUtils.writeInt(outputStream, args.length);
        for (int i = 0; i < args.length; i++) {
            IOUtils.write(outputStream, args[i], storable);
        }
        super.write(outputStream, storable);
    }
    
    private NameRef(InputStream stream, TypeParamRef parent, TypeRef[] args) throws IOException {
        super(IOUtils.readString(stream));
        this.parent = parent;
        this.args = args;
    }
    
    public NameRef(String name) {
        this(name,null,null);
    }
    
    public NameRef(String n,TypeParamRef par,TypeRef[] args) {
        super(getName(n, par, args));
        if (name!=n)
            parent=null;
        else
            parent=par;
        this.args = args==null?ElementInfo.EMPTY_TYPEREFS:args;
    }
    
    private static String getName(String name,TypeParamRef parent,TypeRef[] args) {
        String newName=name;
        
        if (parent!=null && parent instanceof NameRef) {
            NameRef parentName=(NameRef)parent;
            
            if (parentName.parent==null && parentName.args.length==0)
                newName=parentName.name.concat(".").concat(name); // NOI18N
        }
        return newName;
    }

    public boolean equals(Object typeRef) {
        NameRef ref;
        
        if (this==typeRef)
            return true;
        if (!(typeRef instanceof NameRef))
            return false;
        ref=(NameRef)typeRef;
        if (!name.equals(ref.name))
            return false;
        if (!Utilities.compareObjects(parent,ref.parent))
            return false;
        return Utilities.compareObjects(args,ref.args);
    }
    
    String getName() {
        String parentString="";
        
        if (parent!=null) {
            parentString=parent.getName().concat("."); // NOI18N
        }
        return parentString.concat(name);
    }
    
    public int hashCode() {
        if (hashCode!=0) {
            hashCode=name.hashCode();
        
            if (parent!=null)
                hashCode^=parent.hashCode();
            hashCode^=args.hashCode();
        }
        return hashCode;
    }
}
