/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * MemberFieldScope.java
 *
 * Created on April 29, 2003, 3:44 PM
 */

package org.netbeans.modules.javacore.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Method;

/**
 *
 * @author  Tomas Hurka
 */
class MethodScopeMember implements ScopeMember {
    private ClassDefinition javaClass;
    private Map methodsMap;
    
    /** Creates a new instance of MemberFieldScope */
    MethodScopeMember(ClassDefinition jcls) {
        javaClass=jcls;
    }
    
    private void initMethodsMap() {
        Object features[]=javaClass.getContents().toArray();
        
        methodsMap=new HashMap();
        javaClass=null;
        for (int i=0;i<features.length;i++) {
            Object feature=features[i];
            
            if (feature instanceof Method) {
                Method method=(Method)feature;
                String name=method.getName();
                Object ms=methodsMap.get(name);
                
                if (ms==null) {
                    methodsMap.put(name,method);
                } else {
                    if (ms instanceof Method) {
                        List mlist=new ArrayList();
                        mlist.add(ms);
                        methodsMap.put(name,mlist);
                        ms=mlist;
                    }
                    ((List)ms).add(method);
                }
            }
        }
    }
    
    public Object lookup(Object key) {
        if (methodsMap==null)
            initMethodsMap();
        return methodsMap.get(key);
    }
}
