/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.parser;

import java.util.*;

/**
 *
 * @author  Tomas Hurka
 */
public class MethodScope implements ScopeMember {
    
    private MethodScope parentScope;
    private Map positiveCache;
    private Set negativeCache;
    private ArrayList members;
    
    /** Creates a new instance of Scope */
    MethodScope(MethodScope parent) {
        parentScope=parent;
        positiveCache=new HashMap();
        negativeCache=new HashSet();
        members=new ArrayList();
    }
        
    public Object lookup(final Object key) {
        Object val=positiveCache.get(key);
        Object valParent=null;
        
        if (val!=null)
            return val;
        if (negativeCache.contains(key))
            return null;
        val=lookupMembers(key);
        if (parentScope!=null)
            valParent=parentScope.lookup(key);
        val=combine(val,valParent);
        if (val!=null)
            positiveCache.put(key,val);
        else
            negativeCache.add(key);
        return val;
    }
    
    void addMember(final ScopeMember member) {
        positiveCache.clear();
        negativeCache.clear();
        members.add(member);
    }
    
    public boolean equals(Object obj) {
        if (obj!=null && obj instanceof MethodScope) {
            MethodScope sc=(MethodScope)obj;
            if (!members.equals(sc.members))
                return false;
            if (parentScope==null)
                return parentScope==sc.parentScope;
            return parentScope.equals(sc.parentScope);
        }
        return false;
    }
    
    protected Object clone() {
        MethodScope cloned=new MethodScope(parentScope);
        
        cloned.members=(ArrayList)members.clone();
        return cloned;
    }
    
    private Object combine(Object val,Object val1) {
        List valList;
        
        if (val==null)
            return val1;
        if (val1==null)
            return val;
        if (!(val instanceof List)) {
            valList=new ArrayList();
            valList.add(val);
        } else {
            valList=(List)val;
        }
        if (!(val1 instanceof List)) {
            valList.add(val1);
        } else {
            valList.addAll((Collection)val1);
        }
        return valList;
    }
    
    private Object lookupMembers(final Object key) {
        Iterator it=members.iterator();
        Object value=null;
        
        while(it.hasNext()) {
            ScopeMember m=(ScopeMember)it.next();
            Object val=m.lookup(key);
            
            if (val==null)
                continue;
            if (value==null) {
                value=val;
                continue;
            }
            value=combine(value,val);
        }
        return value;
    }
}