/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.modules.javacore.jmiimpl.javamodel.MethodImpl;


/**
 *
 * @author  Tomas Hurka
 */
class MethodInfoMeasure implements Measure {
    public static final MethodInfoMeasure INSTANCE = new MethodInfoMeasure();

    private static final int NAME_WEIGHT = 60;
    private static final int PARAMETERS_WEIGHT = 40;
    
    /** Creates a new instance of ClassMeasure */
    private MethodInfoMeasure() {
    }
    
    /** Compares Java Method to ASTree object.
     * @param refObject Must be Java Method
     * @param asTree
     * @return distance
     */
    public int getDistance(Object refObject, Object ast) {
        if (ast instanceof MethodInfo) {
            MethodInfo astInfo = (MethodInfo) ast;
            MethodImpl refInfo = (MethodImpl) refObject;
            int result;
            TypeRef[] refTypeNames;
            TypeRef[] astTypeNames;
            
            if (astInfo.infoType!=MethodInfo.METHOD_TYPE)
                return INFINITE_DISTANCE;
            result = StringMeasure.INSTANCE.getDistance(refInfo.getName(), astInfo.name) * NAME_WEIGHT;
            
            if (refInfo.isPersisted()) {
                refTypeNames = InfoUtil.getTypeNames(refInfo);
                astTypeNames = InfoUtil.getTypeNames(astInfo.parameters);
                result += new OrderedArrayMeasure(ClassNameMeasure.INSTANCE).getDistance(refTypeNames, astTypeNames) * PARAMETERS_WEIGHT;
            }
            result/=100;
            return result > INFINITE_DISTANCE ? INFINITE_DISTANCE : result;
        }
        return INFINITE_DISTANCE;
    }
}
