/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

/**
 *
 * @author  Martin Matula
 */
interface Measure {
    /** Value representing infinite distance - any distance value equal
     * or greater than this is represented as infinite (i.e. indicates
     * that the compared objects are distinct).
     */
    public int INFINITE_DISTANCE = 1000;
    
    /** Compares two objects and returns 
     * distance between them (value expressing how big the difference between
     * them is).
     * @param first First object to be compared.
     * @param second Second object to be compared.
     * @return Distance between compared objects (0 = objects perfectly match,
     * INFINITE_DISTANCE = objects are completely different)
     */
    public int getDistance(Object first, Object second);
}
