/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import java.lang.reflect.Modifier;
import org.netbeans.jmi.javamodel.Initializer;


/**
 *
 * @author  Tomas Hurka
 */
class InitializerInfoMeasure implements Measure {
    public static final InitializerInfoMeasure INSTANCE = new InitializerInfoMeasure();

    /** Creates a new instance of ClassMeasure */
    private InitializerInfoMeasure() {
    }
    
    /** Compares Initializer to ASTree object.
     * @param refObject Must be Java Initializer
     * @param asTree
     * @return distance
     */
    public int getDistance(Object refObject, Object ast) {
        if (ast instanceof FeatureInfo) {
            FeatureInfo astInfo = (FeatureInfo) ast;
            Initializer refInfo = (Initializer) refObject;
            boolean isStatic=Modifier.isStatic(refInfo.getModifiers());
            
            if (isStatic && astInfo.infoType==FeatureInfo.STATIC_INITIALIZER_TYPE)
                return 0;
            if (!isStatic && astInfo.infoType==FeatureInfo.INSTANCE_INITIALIZER_TYPE)
                return 0;
        }
        return INFINITE_DISTANCE;
    }
}
