/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.modules.javacore.jmiimpl.javamodel.FieldGroupImpl;

/**
 *
 * @author  Tomas Hurka
 */
class FieldGroupInfoMeasure implements Measure {
    public static final FieldGroupInfoMeasure INSTANCE = new FieldGroupInfoMeasure();
    
    /** Creates a new instance of ClassMeasure */
    private FieldGroupInfoMeasure() {
    }
    
    /** Compares Java Field to ASTree object.
     * @param refObject Must be Java Field
     * @param asTree
     * @return distance
     */
    public int getDistance(Object refObject, Object ast) {
        if (ast instanceof FieldGroupInfo) {
            FieldGroupInfo astInfo = (FieldGroupInfo) ast;
            FieldGroupImpl refInfo = (FieldGroupImpl) refObject;
            int result;
            if (refInfo.isPersisted()) {
                result= new ArrayMeasure(FieldInfoMeasure.INSTANCE).getDistance(refInfo.getFields().toArray(), astInfo.fields);
            } else {
                result = 1;
            }
            return result > INFINITE_DISTANCE ? INFINITE_DISTANCE : result;
        }
        return INFINITE_DISTANCE;
    }
}
