/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;

/**
 * @author Pavel Flaska
 */
public final class FieldGroupInfo extends FeatureInfo {

    public static final int FIELDGROUP_TYPE = ASTreeTypes.VARIABLE_DECLARATORS;

    public final FieldInfo[] fields;
    public final TypeRef type;   // type FQN 

    /**
     * Creates a new instance of FieldGroupInfo
     */
    public FieldGroupInfo(ASTree tree, int infoType, int modifiers, TypeRef type, 
                          FieldInfo[] fields, AnnotationInfo[] annotations) {
        super(tree, infoType, null, modifiers, annotations);
        this.type = type;
        this.fields = fields;
    }
}
