/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.modules.javacore.jmiimpl.javamodel.FeatureImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;

/**
 *
 * @author Martin Matula
 */
public class FeatureInfo extends ElementInfo {
    public static final int STATIC_INITIALIZER_TYPE = ASTreeTypes.STATIC_INITIALIZER;
    public static final int INSTANCE_INITIALIZER_TYPE = ASTreeTypes.INSTANCE_INITIALIZER;
    public static final int ENUM_CONSTANT_TYPE = ASTreeTypes.ENUM_CONSTANT;
        
    public final int modifiers;
    public final AnnotationInfo[] annotations; 
    
    public FeatureInfo(ASTree tree, int infoType, String name, int modifiers, AnnotationInfo[] annotations) {
        super(tree, infoType, name);
        this.modifiers = modifiers;
        this.annotations = annotations == null ? EMPTY_ANNOTATIONS: annotations;
    }

    public void doAttribution(FeatureImpl parent) {
        assert parent.getElementInfo() == this;
        ((ResourceInfo) resource.getElementInfo()).doAttribution(parent);
    }
    
    public ASTree getTypeAST(SemiPersistentElement owner) {
        ASTree tree = owner.getASTree();
        if (tree != null) {
            return tree.getSubTrees()[1];
        }
        return null;
    }
}
