/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaEnumImpl;

/**
 *
 * @author  Tomas Hurka
 */
class EnumInfoMeasure implements Measure {
    public static final EnumInfoMeasure INSTANCE = new EnumInfoMeasure();

    private static final int NAME_WEIGHT = 50;
    private static final int CONSTANTS_WEIGHT = 30;
    private static final int MEMBERS_WEIGHT = 20;
    
    /** Creates a new instance of ClassMeasure */
    private EnumInfoMeasure() {
    }
    
    /** Compares JavaClass to ASTree object.
     * @param refObject Must be JavaClass
     * @param asTree
     * @return distance
     */
    public int getDistance(Object refObject, Object ast) {
        JavaEnumImpl refInfo = (JavaEnumImpl) refObject;
        
        if (ast instanceof EnumInfo) {
            EnumInfo astInfo = (EnumInfo) ast;
            int result = 0;

            result += StringMeasure.INSTANCE.getDistance(refInfo.getName(), astInfo.name) * NAME_WEIGHT;
            if (refInfo.isPersisted()) {
                String[] refConstantNames = InfoUtil.getElementNames(refInfo.getConstants());
                String[] astConstantNames = InfoUtil.getElementNames(astInfo.constants);
                result += new ArrayMeasure(StringMeasure.INSTANCE).getDistance(refConstantNames, astConstantNames) * CONSTANTS_WEIGHT;
                String[] refMemberNames = InfoUtil.getElementNames(refInfo.getFeatures());
                String[] astMemberNames = InfoUtil.getElementNames(astInfo.features);
                result += new ArrayMeasure(StringMeasure.INSTANCE).getDistance(refMemberNames, astMemberNames) * MEMBERS_WEIGHT;
            }
            result = result / 100;
            return result > INFINITE_DISTANCE ? INFINITE_DISTANCE : result;
        }
        return INFINITE_DISTANCE;
    }
}
