/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;

/**
 *
 * @author Martin Matula
 */
public final class EnumInfo extends ClassInfo {
    public static final int ENUM_TYPE = ASTreeTypes.ENUM_DECLARATION;

    public final ElementInfo[] constants;

    public EnumInfo(ASTree tree, int infoType, String name, int modifiers,
                    FeatureInfo[] features, NameRef[] interfaces, 
                    ElementInfo[] constants, AnnotationInfo[] annotations) 
    {
        super(tree, infoType, name, modifiers, features, null, interfaces, null, annotations);
        this.constants = constants == null ? EMPTY_FEATURES : constants;
    }

    public ASTree[] getInterfacesAST(SemiPersistentElement owner) {
        ASTree ifcAST;
        ASTree tree = owner.getASTree();
        if (tree != null) {
            ifcAST = tree.getSubTrees()[2];
        } else {
            ifcAST = null;
        }
        return MetadataElement.getChildNodes(ifcAST, ASTreeTypes.TYPE_LIST);
    }

    public ASTree getTypeAST(SemiPersistentElement owner) {
        return null;
    }
}
