/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;

/**
 *
 * @author  Martin Matula
 */
public class ElementInfo {
    public static final int SINGLE_IMPORT_TYPE = ASTreeTypes.SINGLE_TYPE_IMPORT;
    public static final int IMPORT_ON_DEMAND_TYPE = ASTreeTypes.TYPE_IMPORT_ON_DEMAND;

    public static final TypeRef[] EMPTY_TYPEREFS = new TypeRef[0];
    public static final NameRef[] EMPTY_NAMEREFS = new NameRef[0];
    public static final TypeParamRef[] EMPTY_TPREFS = new TypeParamRef[0];

    public static final ClassInfo[] EMPTY_FEATURES = new ClassInfo[0];
    public static final ParameterInfo[] EMPTY_PARAMETERS = new ParameterInfo[0];
    public static final TypeParamInfo[] EMPTY_TYPE_PARAMS = new TypeParamInfo[0];
    public static final AnnotationInfo[] EMPTY_ANNOTATIONS = new AnnotationInfo[0];
    public static final AnnotationValueInfo[] EMPTY_ANNOTATION_VALUES = new AnnotationValueInfo[0];
    
    protected Reference tree;
    protected final ResourceImpl resource;
    private final int firstToken, lastToken;
    private final int astType;

    public final int infoType;
    public final String name;

    public static Reference createASTReference(ASTree tree) {
        return new CachedReference(tree);
    }

    public ElementInfo(ASTree tree, int infoType, String name) {
        if (tree == null) {
            this.tree = null;
            this.astType = this.firstToken = this.lastToken = 0;
            this.resource = null;
        } else {
            this.resource = (ResourceImpl) ((MDRParser) tree.getASTContext()).getResource();
            this.tree = createASTReference(tree);
            this.firstToken = tree.getFirstToken();
            this.lastToken = tree.getLastToken();
            this.astType = tree.getType();
        }
        this.infoType = infoType;
        this.name = name;
    }
    
    public void hardRefAST() {
        resource.getElementInfo().hardRefAST();
    }

    public final Reference getASTree() {
        return tree;
    }

    public ASTree refreshASTree() {
        ASTree parentTree = resource.getASTree();
        ASTProvider parser = (ASTProvider) parentTree.getASTContext();
//        System.err.println(this.getClass().getName() + "." + name + ": refreshing AST for: " + parser);
        ASTree result = parser.findTree(parentTree, firstToken, lastToken, astType);
        this.tree = createASTReference(result);
        return result;
    }

    public ASTree getTypeAST(SemiPersistentElement owner) {
        ASTree tree = owner.getASTree();
        if (tree != null) {
            int type=tree.getType();
            ASTree parts[]=tree.getSubTrees();
            
            if (type==ASTreeTypes.SINGLE_TYPE_IMPORT || type==ASTreeTypes.TYPE_IMPORT_ON_DEMAND)
                return parts[1];
            return parts[0];
        }
        return null;
    }
    
    static class CachedReference extends WeakReference {
	private static final int CACHE_SIZE = Integer.getInteger("org.netbeans.javacore.ASTCache.size", new Integer(2)).intValue(); // NOI18N
        private static final Cache CACHE = new Cache(CACHE_SIZE);
        private static int requests = 0;
        
        CachedReference(ASTree tree) {
            super(tree);
            MDRParser parser = (MDRParser) tree.getASTContext();
            CACHE.put(parser);
        }
        
        public Object get() {
            ASTree result = (ASTree) super.get();
            if (result != null) {
                MDRParser parser = (MDRParser) result.getASTContext();
                CACHE.put(parser);
            }
            return result;
        }
    }


    static class Cache {
        private final MDRParser[] cachedInstances;

        /** Creates a new instance of Cache */
        public Cache(int size) {
            cachedInstances = new MDRParser[size];
        }

        public synchronized void put(MDRParser instance) {
            MDRParser ce = instance;
            for (int i = 0; i < cachedInstances.length; i++) {
                MDRParser temp = cachedInstances[i];
                cachedInstances[i] = ce;
                ce = temp;
                if (temp == null || temp == instance || temp.getFileObject().equals(instance.getFileObject())) {
                    break;
                }
            }
        }

        public void dump() {
            System.err.println("******** Cache dump:");
            for (int i = 0; i < cachedInstances.length; i++) {
                System.err.println(cachedInstances[i].toString());
            }
            System.err.println("*********");
        }
    }
}
