/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import org.netbeans.modules.javacore.jmiimpl.javamodel.ConstructorImpl;

/**
 *
 * @author  Tomas Hurka
 */
class ConstructorInfoMeasure implements Measure {
    public static final ConstructorInfoMeasure INSTANCE = new ConstructorInfoMeasure();

    /** Creates a new instance of ClassMeasure */
    private ConstructorInfoMeasure() {
    }
    
    /** Compares Java constructor to ASTree object.
     * @param refObject Must be Constructor
     * @param asTree
     * @return distance
     */
    public int getDistance(Object refObject, Object ast) {
        if (ast instanceof MethodInfo) {
            MethodInfo astInfo = (MethodInfo) ast;
            ConstructorImpl refInfo = (ConstructorImpl) refObject;
            
            if (astInfo.infoType==MethodInfo.CONSTRUCTOR_TYPE) {
                if (refInfo.isPersisted()) {
                    TypeRef[] refTypeNames = InfoUtil.getTypeNames(refInfo);
                    TypeRef[] astTypeNames = InfoUtil.getTypeNames(astInfo.parameters);
                    return new OrderedArrayMeasure(ClassNameMeasure.INSTANCE).getDistance(refTypeNames, astTypeNames);
                } else {
                    return 1;
                }
            }
        }
        return INFINITE_DISTANCE;
    }
}
