/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.parser;

import java.util.List;
import java.lang.reflect.Modifier;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;

/**
 *
 * @author  Tomas Hurka
 */
class ClassInfoMeasure implements Measure {
    public static final ClassInfoMeasure INSTANCE = new ClassInfoMeasure();

    private static final int TYPE_WEIGHT = 100;
    private static final int NAME_WEIGHT = 60;
    private static final int EXTENDS_WEIGHT = 10;
    private static final int IMPLEMENTS_WEIGHT = 10;
    private static final int MEMBERS_WEIGHT = 20;
    
    /** Creates a new instance of ClassMeasure */
    private ClassInfoMeasure() {
    }
    
    /** Compares JavaClass to ASTree object.
     * @param refObject Must be JavaClass
     * @param asTree
     * @return distance
     */
    public int getDistance(Object refObject, Object ast) {
        if (ast instanceof ClassInfo) {
            JavaClassImpl refInfo = (JavaClassImpl) refObject;
            ClassInfo astInfo = (ClassInfo) ast;
            int result = 0;

            if (refInfo.isInterface() != Modifier.isInterface(astInfo.modifiers)) {
                result = TYPE_WEIGHT ;
            }
            result += StringMeasure.INSTANCE.getDistance(refInfo.getName(), astInfo.name) * NAME_WEIGHT;
            
            if (refInfo.isPersisted()) {
                result += ClassNameMeasure.INSTANCE.getDistance(refInfo.getSuperclassRef(), astInfo.superclass) * EXTENDS_WEIGHT;
                List ifcRefs = refInfo.getInterfaceRefs();
                result += new ArrayMeasure(ClassNameMeasure.INSTANCE).getDistance(ifcRefs == null ? new Object[0] : ifcRefs.toArray(), astInfo.interfaces) * IMPLEMENTS_WEIGHT;
                String[] refMemberNames = InfoUtil.getElementNames(refInfo.getFeatures());
                String[] astMemberNames = InfoUtil.getElementNames(astInfo.features);
                result += new ArrayMeasure(StringMeasure.INSTANCE).getDistance(refMemberNames, astMemberNames) * MEMBERS_WEIGHT;
            }
            result = result / 100;
            return result > INFINITE_DISTANCE ? INFINITE_DISTANCE : result;
        } else if (ast instanceof TypeRef) {
            TypeRef tr = SemiPersistentElement.typeToTypeRef((JavaClass) refObject);
            if (tr.equals(ast))
                return 0;
            return INFINITE_DISTANCE;
        }
        return INFINITE_DISTANCE;
    }
}
