/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ParserTokens;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 * @author Martin Matula
 */
public abstract class WildCardImpl extends TransientElement implements WildCard {
    private boolean isLower;
    private TypeReference boundName;
    private Type bound;

    public WildCardImpl(StorableObject o) {
        super(o);
    }

    public boolean isLower() {
        if (isChanged(CHANGED_IS_LOWER)) {
            return isLower;
        } else {
            ASTree lower = getASTree().getSubTrees()[0];
            return lower == null || lower.getType() == ParserTokens.EXTENDS;
        }
    }

    public void setLower(boolean newValue) {
        objectChanged(CHANGED_IS_LOWER);
        isLower = newValue;
    }

    public TypeReference getBoundName() {
        if (!childrenInited) {
            initChildren();
        }
        return boundName;
    }

    public void setBoundName(TypeReference newValue) {
        objectChanged(CHANGED_BOUND);
        changeChild(getBoundName(), newValue);
        this.boundName = newValue;
        this.bound = null;
    }

    public Type getBound() {
        if (bound == null || !isChanged(CHANGED_BOUND)) {
            return (Type) getBoundName().getElement();
        } else {
            return bound;
        }
    }

    public void setBound(Type newValue) {
        bound = newValue;
        MultipartIdClass proxy = ((JavaModelPackage) refImmediatePackage()).getMultipartId();
        setBoundName(proxy.createMultipartId(newValue.getName(), null, null));
    }

    public List getChildren() {
        List list = new ArrayList(1);
        addIfNotNull(list, getBoundName());
        return list;
    }

    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        ASTree[] children = getASTree().getSubTrees();
        if (tree != null) {
        boundName = (TypeReference) initOrCreate(boundName, children[1]);
        }
        childrenInited = true;
    }

    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        buf.append('?');
        TypeReferenceImpl boundName = (TypeReferenceImpl) getBoundName();
        if (boundName != null) {
            buf.append(isLower() ? " extends " : " super "); // NOI18N
            buf.append(boundName.getSourceText());
        }
        return buf.toString();
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();

        if (isChanged(CHANGED_IS_LOWER) || isChanged(CHANGED_BOUND)) {
            replaceNode(diff, parser, tree, getSourceText(), 0, null);
        } else if (isChanged(CHANGED_CHILDREN)) {
            ((MetadataElement) getBoundName()).getDiff(diff);
        }
    }

    void setData(boolean isLower, TypeReference boundName) {
        this.isLower = isLower;
        changeChild(null, boundName);
        this.boundName = boundName;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(boundName);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }

    public void replaceChild(Element oldElement,Element newElement){
        if (childrenInited) {
            if (oldElement.equals(boundName)) {
                setBoundName((TypeReference) newElement);
            }
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getWildCard().createWildCard(
                isLower(), (TypeReference) duplicateElement(getBoundName(), targetExtent));
    }
}
