/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.jmi.javamodel.WhileStatement;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author  Martin Matula
 */
public abstract class WhileStatementImpl extends ConditionImpl implements WhileStatement {
    protected Statement body = null;
    
    /** Creates a new instance of WhileStatementImpl */
    public WhileStatementImpl(StorableObject o) {
        super(o);
    }
    
    public void setBody(Statement body) {
        objectChanged(CHANGED_BODY);
        changeChild(getBody(), body);
        this.body = body;
    }

    public List getChildren() {
        List list = new ArrayList(4);
        addIfNotNull(list, getBody());
        list.addAll(super.getChildren());
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            expression = (Expression) initOrCreate(expression, parts[0]);
            body = (Statement) initOrCreate(body, parts[1]);
        }
        childrenInited = true;
    }
    
    public Statement getBody() {
        if (!childrenInited) {
            initChildren();
        }
        return body;
    }
    
    String getRawText() {
        StringBuffer buf = new StringBuffer();
        StatementImpl cond = (StatementImpl) getExpression();
        StatementImpl body = (StatementImpl) getBody();
        
        formatElementPart(WHILE_KEYWORD, buf);
        formatElementPart(STMT_OPEN_BRACKET, buf);
        buf.append(cond.getSourceText());
        formatElementPart(STMT_CLOSE_BRACKET, buf);
        buf.append(body.getSourceText());
        return buf.toString();
    }
    
    public void getDiff(List diff){
        ASTProvider parser = getParser();
        
        ASTree[] children = getASTree().getSubTrees();
        
        getChildDiff(diff, parser, children[0], (MetadataElement) getExpression(), CHANGED_EXPRESSION);
        getChildDiff(diff, parser, children[1], (MetadataElement) getBody(), CHANGED_BODY);
    }
    
    void setData(Expression expression, Statement body) {
        changeChild(null, expression);
        changeChild(null, body);
        this.expression = expression;
        this.body = body;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(body);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(body)) {
                setBody((Statement)newElement);
            } else
                super.replaceChild(oldElement,newElement);
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getWhileStatement().createWhileStatement(
                (Expression) duplicateElement(getExpression(), targetExtent), 
                (Statement) duplicateElement(getBody(), targetExtent)
               );
    }
}
