/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jmi.model.MofClass;
import javax.jmi.model.NameNotFoundException;
import javax.jmi.reflect.ConstraintViolationException;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.parser.MDRParser;

/**
 *
 * @author  Martin Matula
 */
public abstract class UnresolvedClassImpl extends MetadataElement implements UnresolvedClass {
    String name = null;
    private static final String message = "Unresolved class does not support requested operation!"; // NOI18N
    
    /** Creates a new instance of PackageImpl */
    public UnresolvedClassImpl(StorableObject s) {
        super(s);
    }

    protected void rollback() {
    }

    protected Object getInternalForm() {
        return getName();
    }
    
    public String getSourceText() {
        return getName();
    }
    
    public void getDiff(List diff) {
    }
    
    public String getName() {
        return name;
    }
    
    public void setName(String name) {
        RefObject nameAttr = null;
        try {
            nameAttr = ((MofClass) refMetaObject()).lookupElementExtended("name"); // NOI18N
        } catch (NameNotFoundException e) {
            // ignore
        }
        throw new ConstraintViolationException(this, nameAttr, "Name attribute is readonly."); // NOI18N
    }

    public Collection getReferences() {
        return Collections.EMPTY_LIST;
    }

    public boolean isInterface() {
        return false;
    }
    
    public boolean isInner() {
        return false;
    }
    
    public ClassDefinition getDeclaringClass() {
        return null;
    }
    
    public JavaClass getSuperClass() {
        if ("java.lang.Object".equals(name)) { // NOI18N
            return null;
        } else {
            return (JavaClass) ((JavaModelPackage)refImmediatePackage()).getType().resolve("java.lang.Object"); // NOI18N
        }
    }
    
    public void setSuperClass(JavaClass jcls) {
        throw new UnsupportedOperationException();
    }
    
    public List getInterfaces() {
        return Collections.EMPTY_LIST;
    }
    
    public List getFeatures() {
        return Collections.EMPTY_LIST;
    }
    
    public void setSuperClassName(MultipartId newValue) {
        throw new UnsupportedOperationException();
    }
    
    public void setSimpleName(java.lang.String newValue) {
         throw new UnsupportedOperationException();
    }
    
    public void setModifiers(int newValue) {
         throw new UnsupportedOperationException();
    }
    
    public void setJavadocText(java.lang.String newValue) {
         throw new UnsupportedOperationException();
    }
    
    public void setJavadoc(JavaDoc newValue) {
         throw new UnsupportedOperationException();
    }
    
    public void setInterface(boolean newValue) {
         throw new UnsupportedOperationException();
    }
    
    public List getTypeParameters() {
        return Collections.EMPTY_LIST;
    }
    
    public MultipartId getSuperClassName() {
        return null;
    }
    
    public Collection getSubClasses() {
        return Collections.EMPTY_LIST;
    }
    
    public java.lang.String getSimpleName() {
        return JavaClassImpl.getSimpleName(name);
    }
    
    public int getModifiers() {
        return 0;
    }
    
    public int getSourceModifiers() {
        return 0;
    }
    
    public Method getMethod(java.lang.String name, List parameters, boolean includeSupertypes) {
        return null;
    }
    
    public java.lang.String getJavadocText() {
        return null;
    }
    
    public JavaDoc getJavadoc() {
        return null;
    }
    
    public List getInterfaceNames() {
        return Collections.EMPTY_LIST;
    }
    
    public JavaClass getInnerClass(java.lang.String simpleName, boolean includeSupertypes) {
        return null;
    }
    
    public Collection getImplementors() {
        return Collections.EMPTY_LIST;
    }
    
    public Field getField(java.lang.String name, boolean includeSupertypes) {
        return null;
    }
    
    public List getContents() {
        return Collections.EMPTY_LIST;
    }
    
    public Constructor getConstructor(List parameters, boolean includeSupertypes) {
        return null;
    }
    
    public List getAnnotations() {
        return Collections.EMPTY_LIST;
    }

    public void replaceChild(Element element, Element element1) {
        throw new UnsupportedOperationException(message);
    }

    public int getPartEndOffset(ElementPartKind elementPartKind) {
        throw new UnsupportedOperationException(message);
    }

    public java.util.List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public int getStartOffset() {
        throw new UnsupportedOperationException(message);
    }

    public java.util.Collection findSubTypes(boolean param) {
        return Collections.EMPTY_LIST;
    }

    public int getPartStartOffset(ElementPartKind elementPartKind) {
        throw new UnsupportedOperationException(message);
    }

    public Resource getResource() {
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isSubTypeOf(ClassDefinition classDefinition) {
        if ("java.lang.Object".equals(classDefinition.getName()) || (this.equals(classDefinition))) { // NOI18N
            return true;
        } else {
            return false;
        }
    }

    public Element duplicate(JavaModelPackage targetExtent) {
        throw new UnsupportedOperationException(message);
    }

    public boolean isValid() {
        return true;
    }
    
    public MDRParser getParser() {
        return null;
    }

    public int getEndOffset() {
        throw new UnsupportedOperationException(message);
    }

    public void setDeprecated(boolean param) {
        throw new UnsupportedOperationException(message);
    }
    
}
