/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import java.util.*;
import org.netbeans.jmi.javamodel.Element;

/**
 *
 * @author Martin Matula
 */
public abstract class TypeReferenceImpl extends ElementReferenceImpl implements TypeReference {
    private MultipartId parent;

    /** Creates a new instance of MultipartIdImpl */
    public TypeReferenceImpl(StorableObject o) {
        super(o);
    }
    
    public MultipartId getParent() {
        if (!childrenInited) {
            initChildren();
        }
        return parent;
    }

    public void setParent(MultipartId parent) {
        MultipartId oldParent = getParent();
        if (parent != oldParent) {
            objectChanged(CHANGED_PARENT);
            changeChild(oldParent, parent);
            this.parent = parent;
        }
    }

    void setData(String name, MultipartId parent) {
        super.setData(name);
        changeChild(null, parent);
        this.parent = parent;
    }

    public List getChildren() {
        List list = new ArrayList(1);
        addIfNotNull(list, getParent());
        return list;
    }

    protected void initChildren() {
        childrenInited = false;
        ASTree[] children = getASTree().getSubTrees();
        if (children == null || children.length < 2) {
            parent = null;
        } else {
            parent = (MultipartId) initOrCreate(parent, children[0]);
        }
        childrenInited = true;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(parent);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }

    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(parent)) {
                setParent((MultipartId)newElement);
            }
        }
    }

    public void setName(String name) {
        super.setName(name);
        childChanged(this);
    }
    
    void childChanged(MetadataElement element) {
        MetadataElement parent = (MetadataElement) refImmediateComposite();
        if (parent!=null){
            parent.childChanged(this);
        }
    }
}
