/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import javax.jmi.reflect.ConstraintViolationException;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.*;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.*;
import org.openide.util.Utilities;

/**
 *
 * @author  Pavel Flaska, Jan Becicka, Martin Matula
 */
public abstract class TypeParameterImpl extends SemiPersistentElement implements TypeParameter {
    
    protected ReferenceListWrapper interfaces;
    private LightAttrList interfaceNames;
    private MultipartId superClassName;
    
    private static final ElementInfo DEFAULT_INFO = new TypeParamInfo(null, TypeParamInfo.TYPEPARAM_TYPE, null, null);
    
    /** Creates a new instance of TypeParamImpl */
    public TypeParameterImpl(StorableObject s) {
        super(s);
    }
    
    protected ElementInfo getDefaultInfo() {
        return DEFAULT_INFO;
    }
    
    public List getInterfaces() {
        checkUpToDate();
        if (interfaces == null) {
            initInterfaces();
        }
        return interfaces;
    }
    
    protected void matchPersistent(ElementInfo info) {
        super.matchPersistent(info);
        TypeParamInfo tpInfo =  (TypeParamInfo)info;
        
        if (!isPersisted()) {
            setPersisted(true);
            persist();
            setBoundsRef(tpInfo.bounds);
        } else {
            ArrayList ifcNames = new ArrayList(tpInfo.bounds.length);
            TypeParamRef jclsRef = splitBounds(tpInfo.bounds, ifcNames);
            if (!Utilities.compareObjects(jclsRef, getSuperclassRef())) {
                setSuperclassRef(jclsRef);
            }
            processMembers(getInterfaces(), ifcNames.toArray());
        }
    }
    
    public JavaClass getSuperClass() {
        checkUpToDate();
        return (JavaClass) resolveType(getSuperclassRef());
    }

    /**
     * Sets the value of reference superClass. See {@link #getSuperClass} for
     * description on the reference.
     * @param newValue New value to be set.
     */
    public void setSuperClass(JavaClass newValue) {
        TypeParamRef sc;
        if (newValue == null) {
            sc = NameRef.java_lang_Object;
            newValue = (JavaClass) resolveType(sc);
        } else {
            sc = (TypeParamRef) typeToTypeRef(newValue);            
        }
        _setSuperClass(sc, (MultipartId) typeRefToTypeReference(sc, 0));
    }
    
    private void _setSuperClass(TypeParamRef superClass, MultipartId superClassName) {
        if (!disableChanges) {
            objectChanged(CHANGED_EXTENDS);
            changeChild(getSuperClassName(), superClassName);
            this.superClassName = superClassName;
        }
        setSuperclassRef(superClass);
    }

    public MultipartId getSuperClassName() {
        checkUpToDate();
        if (!childrenInited) {
            initChildren();
        }
        return superClassName;
    }

    public void setSuperClassName(org.netbeans.jmi.javamodel.MultipartId newValue) {
        TypeParamRef sc = (TypeParamRef) typeReferenceToTypeRef(newValue, 0);
        if (sc == null) {
            sc = NameRef.java_lang_Object;
        }
        _setSuperClass(sc, newValue);
    }

    public List getInterfaceNames() {
        checkUpToDate();
        if (!childrenInited) {
            initChildren();
        }
        return interfaceNames;
    }

    private ReferenceListWrapper initInterfaces() {
        List interfaceNames = getInterfaceRefs();
        if (interfaceNames == null) {
            interfaceNames = new ArrayList();
        } else if (!(interfaceNames instanceof ArrayList)) {
            interfaceNames = new ArrayList(interfaceNames);
        }
        // list of superinterfaces is transient
        TypeList _interfaces = new TypeList(this, (ArrayList) interfaceNames) {
            protected void updateParent() {
                setInterfaceRefs(innerList);
            }
        };
        if (interfaces == null) {
            ImplementsImpl implementsImpl = (ImplementsImpl)(((JavaModelPackage) refImmediatePackage()).getImplements());
            interfaces = new ReferenceListWrapper(_getDelegate().getMdrStorage(), implementsImpl, this, "interfaces", this, CHANGED_IMPLEMENTS, _interfaces); // NOI18N
        } else {
            interfaces.setInnerList(_interfaces);
        }
        return interfaces;
    }
    
    private TypeParamRef splitBounds(TypeParamRef[] interfaceNames, List ifcNames) {
        if (interfaceNames == null)
            return null;
        TypeParamRef sc = null;
        for (int i = 0; i < interfaceNames.length; i++) {
            if (i == 0) {
                JavaClass cls = (JavaClass) resolveType(interfaceNames[i]);
                if (!cls.isInterface()) {
                    sc = interfaceNames[i];
                    continue;
                }
            }
            ifcNames.add(interfaceNames[i]);
        }
        return sc == null ? NameRef.java_lang_Object : sc;
    }

    protected void setData(MultipartId superClassName, List interfaceNames) {
        changeChild(null, superClassName);
        this.superClassName = superClassName;
        this.interfaceNames = createChildrenList("interfaceNames", interfaceNames, CHANGED_IMPLEMENTS); // NOI18N
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree ifaceAST = null;
        ASTree tree = getASTree();
        
        if (tree != null) {
          ifaceAST = tree.getSubTrees()[1];  
        }
        interfaceNames = createChildrenList(interfaceNames, "interfaceNames", ifaceAST, ASTreeTypes.BOUND_LIST, CHANGED_IMPLEMENTS, false); // NOI18N
        if (!interfaceNames.isEmpty()) {
            JavaClass cls = (JavaClass) ((MultipartId) interfaceNames.get(0)).getElement();
            if (!cls.isInterface()) {
                MultipartId element = (MultipartId) interfaceNames.getInnerList().remove(0);
                changeChild(null, element);
                superClassName = element;
            }
        }
        childrenInited = true;
    }

    protected void matchElementInfo(ElementInfo newInfo) {
        super.matchElementInfo(newInfo);
        resetChildren();
    }

    public List getChildren() {
        ArrayList children = new ArrayList();
        addIfNotNull(children, getSuperClassName());
        children.addAll(getInterfaceNames());
        return children;
    }

    protected void resetChildren() {
        super.resetChildren();
        if (childrenInited) {
            if (superClassName != null) {
                MultipartId temp = superClassName;
                changeChild(superClassName, null);
                superClassName = null;
                temp.refDelete();
            }
            deleteChildren(interfaceNames);
            interfaceNames = null;
            childrenInited = false;
        }
    }
    
    protected void _delete() {
        if (childrenInited) {
            deleteChildren(interfaceNames);
            deleteChild(superClassName);
        }
        super._delete();
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        
        StringBuffer buf = new StringBuffer();
        buf.append(getName());
        boolean hasExtends = false;
        if (getSuperClassName() != null) {
            buf.append(" extends " + ((MultipartIdImpl) getSuperClassName()).getSourceText()); //NOI18N
            hasExtends = true;
        }
        
        for (Iterator it = getInterfaceNames().iterator(); it.hasNext();) {
            if (!hasExtends) {
                buf.append(" extends "); // NOI18N
                hasExtends = true;
            } else {
                buf.append(" & "); // NOI18N
            }
            buf.append(((MetadataElement) it.next()).getSourceText()); 
        }
        
        return buf.toString();
    }
    
    public void getDiff(List diffList) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();

        // name
        if (isChanged(CHANGED_NAME)) {
            replaceNode(diffList, parser, children[0], getName(), 0, null);
        }

        int startOffset = children[1] == null ? parser.getToken(children[0].getLastToken()).getEndOffset() : parser.getToken(children[1].getFirstToken()).getStartOffset();

        getCollectionDiff(diffList, parser, CHANGED_EXTENDS | CHANGED_IMPLEMENTS, children[1], ASTreeTypes.BOUND_LIST, getChildren(), startOffset, " & ", " extends "); // NOI18N
    }
    
    public void throwReadOnly(String name) {
        throw new ConstraintViolationException(null, null, "Cannot change " + name + " of a type parameter."); // NOI18N
    }
    
    public void setModifiers(int mod) {
        throwReadOnly("modifiers"); // NOI18N
    }
    
    public int getModifiers() {
        return 0;
    }
    
    public ClassDefinition getDeclaringClass() {
        return null;
    }

    public List getAnnotations() {
        return Collections.EMPTY_LIST;
    }
    
    public List getTypeParameters() {
        return Collections.EMPTY_LIST;
    }
    
    public List getContents() {
        return Collections.EMPTY_LIST;
    }
    
    public List getFeatures() {
        return Collections.EMPTY_LIST;
    }
    
    public JavaDoc getJavadoc() {
        return null;
    }
    
    public String getJavadocText() {
        return null;
    }

    public boolean isInterface() {
        return false;
    }

    public void setInterface(boolean newValue) {
        throwReadOnly("isInterface"); // NOI18N
    }
    
    public java.lang.String getSimpleName() {
        return getName();
    }

    public void setSimpleName(java.lang.String newValue) {
        setName(newValue);
    }
    
    public java.util.Collection getImplementors() {
        return Collections.EMPTY_LIST;
    }
    
    public java.util.Collection getSubClasses() {
        return Collections.EMPTY_LIST;
    }
    
    public boolean isInner() {
        return false;
    }
    
    public boolean isDeprecated() {
        return false;
    }
    
    public void setDeprecated(boolean newValue) {
        throwReadOnly("isDeprecated"); // NOI18N
    }
    
    public Field getField(final String name, final boolean includeSupertypes) {
        return (Field) doQuery(new Query() {
            public Object query(JavaClass cls) {
                return cls.getField(name, includeSupertypes);
            }
        }, includeSupertypes);
    }

    public Method getMethod(final String name, final List parameters, final boolean includeSupertypes) {
        return (Method) doQuery(new Query() {
            public Object query(JavaClass cls) {
                return cls.getMethod(name, parameters, includeSupertypes);
            }
        }, includeSupertypes);
    }

    public JavaClass getInnerClass(final String simpleName, final boolean includeSupertypes) {
        return (JavaClass) doQuery(new Query() {
            public Object query(JavaClass cls) {
                return cls.getInnerClass(simpleName, includeSupertypes);
            }
        }, includeSupertypes);
    }
    
    public Constructor getConstructor(java.util.List parameters, boolean includeSupertypes) {
        return null;
    }
    
    public boolean isSubTypeOf(ClassDefinition clazz) {
        return ClassDefinitionImpl.isSubTypeOf(this, clazz);
    }

    private Object doQuery(Query query, boolean includeSupertypes) {
        Object result = null;
        if (includeSupertypes) {
            result = query.query(getSuperClass());
            for (Iterator it = getInterfaces().iterator(); it.hasNext() && result == null;) {
                result = query.query((JavaClass) it.next());
            }
        }
        return result;
    }
    
    private interface Query {
        Object query(JavaClass cls);
    }
    
    protected ASTree getPartTree(ElementPartKind part) {
        if (ElementPartKindEnum.HEADER.equals(part)) {
            return getASTree().getSubTrees()[0];
        }
        throw new IllegalArgumentException("Invalid part for this element: " + part); // NOI18N
    }


    void setBoundsRef(TypeParamRef[] bounds) {
        List interfaces = new ArrayList(bounds == null ? 0 : bounds.length);
        setSuperclassRef(splitBounds(bounds, interfaces));
        setInterfaceRefs(interfaces);
    }

    /*
    private List getBoundsRef() {
        return (List) _getDelegate().getSlot1();
    }
     */
    
    public void setJavadocText(String text) {
        throw new UnsupportedOperationException();
    }
    
    protected void setSuperclassRef(TypeParamRef sc) {
        _getDelegate().setSlot1(sc);
    }
    
    private TypeParamRef getSuperclassRef() {
        return (TypeParamRef) _getDelegate().getSlot1();
    }
    
    protected void setInterfaceRefs(List ifcs) {
        _getDelegate().setSlot2(ifcs);
    }
    
    private List getInterfaceRefs() {
        return (List) _getDelegate().getSlot2();
    }
    
    protected abstract String super_getJavadocText();
    protected abstract void super_setJavadocText(String text);

    public boolean isPersisted() {
        return super_getJavadocText() != null;
    }
    
    public void setPersisted(boolean persisted) {
        super_setJavadocText(persisted ? "" : null);
    }
    
    public Collection findSubTypes(boolean recursively) {
        return Collections.EMPTY_LIST;
    }

    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getTypeParameter().createTypeParameter(
                getName(),
                duplicateList(getAnnotations(), targetExtent),
                getModifiers(),
                null,
                (JavaDoc) duplicateElement(getJavadoc(), targetExtent),
                duplicateList(getContents(), targetExtent),
                (MultipartId) duplicateElement(getSuperClassName(), targetExtent),
                duplicateList(getInterfaceNames(), targetExtent),
                duplicateList(getTypeParameters(), targetExtent)
               );
    }
}
