/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Arrays;
import java.util.List;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.modules.javacore.parser.TypeParamRef;

/**
 * @author Pavel Flaska
 */
public abstract class TypeParameterClassImpl extends SemiPersistentClass implements TypeParameterClass {
    
    public TypeParameterClassImpl(StorableClass s) {
        super(s);
    }
    
    public TypeParameter createTypeParameter() {
        return create(null, (MultipartId) null, null);
    }

    public TypeParameter createTypeParameter(String name, List annotations, int modifiers, String javadocText, JavaDoc javadoc, List contents, MultipartId superClassName, List interfaceNames, List typeParameters) {
        return create(name, superClassName, interfaceNames);
    }

    protected abstract TypeParameter super_createTypeParameter(String name, List annotations, int modifiers, String javadocText, JavaDoc javadoc, List contents, MultipartId superClassName, List interfaceNames, List typeParameters);

    public TypeParameterImpl create(String name, TypeParamRef[] bounds, boolean isTransient) {
        TypeParameterImpl result;
        if (isTransient) {
            result = (TypeParameterImpl) createTransient();
            boolean changes = result.disableChanges;
            result.disableChanges = true;
            try {
                result.setName(name);
            } finally {
                result.disableChanges = changes;
            }
        } else {
            result = (TypeParameterImpl) super_createTypeParameter(name, null, 0, null, null, null, null, null, null);
        }
        result.setBoundsRef(bounds == null ? null : bounds);
        return result;
    }

    private TypeParameter create(String name, MultipartId superClassName, List interfaceNames) {
        TypeParameterImpl result = create(name, null, false);
        result.setNew();
        result.setData(superClassName, interfaceNames);
        return result;
    }
    
    public org.netbeans.jmi.javamodel.Type resolve(java.lang.String name) {
        JavaModelPackage pkg = (JavaModelPackage) refImmediatePackage();
        return pkg.getType().resolve(name);
    }
}
