/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Iterator;
import org.netbeans.jmi.javamodel.ArrayClass;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.TypeClass;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.mdr.storagemodel.StorableClass;

/**
 *
 * @author  Martin Matula
 */
public abstract class TypeClassImpl extends SemiPersistentClass implements TypeClass {
    
    /** Creates a new instance of JavaClassClassImpl */
    public TypeClassImpl(StorableClass s) {
        super(s);
    }

    public Type resolve(String name) {
        if (name == null) return null; // throw new NullPointerException();
        
        _lock(false);
        try {
            int dimension = 0;
            while (name.endsWith("[]")) { // NOI18N
                dimension++;
                name = name.substring(0, name.length() - 2);
            }

            JavaModelPackage pkg = (JavaModelPackage) refImmediatePackage();
            PrimitiveTypeClassImpl pt = (PrimitiveTypeClassImpl) pkg.getPrimitiveType();
            Type result = pt.resolveType(name);
            if (result == null) {
                JavaClassClassImpl cls = (JavaClassClassImpl) pkg.getJavaClass();
                result = cls.resolveClass(name, true);
            }
            if (result == null) {
                // class was not found - create UnresolvedClass
                UnresolvedClassClassImpl cls = (UnresolvedClassClassImpl) pkg.getUnresolvedClass();
                result = cls.resolveUnresolved(name);
            }
            if (dimension > 0) {
                ArrayClass ar = ((JavaModelPackage)result.refImmediatePackage()).getArray();
                for (int i = 0; i < dimension; i++) {
                    result = ar.resolveArray(result);
                }
            }
            return result;
        } finally {
            _unlock();
        }
    }
    
    public static Type getRawType(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType) type).getDefinition();
        } else if (type instanceof Array) {
            int dimCount = 1;
            Type elemType = ((Array) type).getType();
            while (elemType instanceof Array) {
                elemType = ((Array) elemType).getType();
                dimCount++;
            }
            Type rawElemType=getRawType(elemType);
            if (!elemType.equals(rawElemType)) {
                ArrayClass proxy = ((JavaModelPackage)type.refOutermostPackage()).getArray();
                type = rawElemType;
                for (; dimCount > 0; dimCount--) {
                    type = proxy.resolveArray(type);
                }
            }
            return type;
        } else if (type instanceof TypeParameter) {
            TypeParameter typePar = (TypeParameter) type;
            JavaClass superClass = typePar.getSuperClass();
            
            if ("java.lang.Object".equals(superClass.getName())) {
                Iterator intIt = superClass.getInterfaces().iterator();
                
                if (intIt.hasNext()) {
                    superClass=(JavaClass) intIt.next();
                }
            }
            return getRawType(superClass);
        }
        return type;
    }
}
