/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.lang.ref.Reference;
import java.util.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.MDRParser;
import org.openide.ErrorManager;

/**
 *
 * @author  Martin Matula
 */
public abstract class TransientElement extends MetadataElement {
    private Reference tree;
    private int firstToken, lastToken;
    private int astType;
    private ResourceImpl resource;

    private boolean isNew = false;

    /** Creates a new instance of StatementBlockImpl */
    public TransientElement(StorableObject o) {
        super(o);
    }

    protected final void init(ASTree tree) {
        MDRParser parser = (MDRParser) tree.getASTContext();
        if (parser == null) {
            // issue #46267
            JMManager.getLog().notify(ErrorManager.INFORMATIONAL, new Exception("getASTContext() returned null for: " + tree)); // NOI18N
            JMManager.getLog().log("Using Element.getResource() instead of parser.getResource() to retrieve the parent resource...");
            this.resource = (ResourceImpl) getResource();
        } else {
            this.resource = (ResourceImpl) parser.getResource();
        }
        this.tree = ElementInfo.createASTReference(tree);
        this.firstToken = tree.getFirstToken();
        this.lastToken = tree.getLastToken();
        this.astType = tree.getType();
        // go down via containment hierarchy and force ASTInfo renewal
        if (childrenInited) {
            initChildren();
        }
        resetChange();
    }

    public final ASTree getASTree() {
        initCheck();
        if (tree == null) return null;
        ASTree result = (ASTree) tree.get();
        if (result == null) {
            ASTree parentTree = resource.getASTree();
            MDRParser parser = (MDRParser) parentTree.getASTContext();
            result = parser.findTree(parentTree, firstToken, lastToken, astType);
            this.tree = ElementInfo.createASTReference(result);
        }
        return result;

    }

    public final MDRParser getParser() {
        ASTree tree = getASTree(); // make sure that parser is initialized
        if (tree == null) return null;
        return (MDRParser) tree.getASTContext();
    }

    protected final Object getInternalForm() {
        return getASTree();
    }

    protected final boolean isInitialized() {
        return (tree != null) || isNew;
    }

    protected final void uninitialize() {
        tree = null;
        resource = null;
        isNew = false;
    }

    /** Overriding methods must call super.setNew() */
    protected void setNew() {
        setChanged();
        isNew = true;
        childrenInited = true;
    }

    protected final boolean isNew() {
        return isNew;
    }

    public void getCollectionDiff(List diff, ASTProvider parser, int changeMask, ASTree parentNode, int groupNodeType, Collection newElements, int endOffset, String separator) {
        ASTree[] oldElements = getChildNodes(parentNode, groupNodeType);
        getCollectionDiff(diff, parser, changeMask, oldElements, newElements, endOffset, separator);
    }

    protected String getIndentation() {
        super.getIndentation();
        Object comp = refImmediateComposite();
        if (comp instanceof SemiPersistentElement) {
            return ((SemiPersistentElement) refImmediateComposite()).getIndentation().concat(INDENTATION);
        } else {
            return ((TransientElement) refImmediateComposite()).getIndentation().concat(INDENTATION);
        }
    }

    protected void printListOfItems (String origSrc, StringBuffer buf, ASTree[] children, Map oldItems, List items) {
        ASTProvider parser = getParser();
        if (oldItems == null) {
            oldItems = new HashMap();
            for (int x = 0; x < children.length; x++) {
                Token tok = (x < children.length - 1) ?
                    parser.getToken(children[x].getLastToken() + 1) : null;
                oldItems.put(children[x], tok);
            }
        }
        Iterator iter = items.iterator();
        TransientElement item = null;
        int x;
        for (x = 0; iter.hasNext(); x++) {
            item = (TransientElement) iter.next();
            ASTree itemTree = item.getASTree();
            if (!((x < children.length) && (itemTree == children[x]) && !item.isChanged())) {
                x--;
                break;
            }
        }
        if ((x > -1) && (item != null)) {
            Token token = null;
            if (x == (children.length - 1)) {
                item = null;
                token = parser.getToken(children[x].getLastToken());
            } else {
                token = parser.getToken(children[x].getLastToken() + 1);
            }
            int start = parser.getToken(children[0].getFirstToken()).getStartOffset();
            buf.append(origSrc.substring(start, token.getEndOffset()));
        }

        while (item != null) {
            ASTree itemTree = item.getASTree();
            Token tok = (Token) oldItems.get (itemTree);
            buf.append(item.getSourceText());
            if (iter.hasNext()) {
                if (tok != null) {
                    buf.append(origSrc.substring(tok.getStartOffset(), tok.getEndOffset()));
                } else {
                    buf.append(", "); // NOI18N
                }
            }
            item = iter.hasNext() ? (StatementImpl) iter.next() : null;
        } // while
    }

    protected void invalidate() {
        super._delete();
    }

    /** Part ot the rollback mechanism.
     *
     * In the case of any rollback, all classes should be rebuilt from ASTrees.
     * The layout for method is the next one:
     * protected void reset() {
     *   .. do your own job...
     *   super.reset()
     * }
     */
    protected final void rollback() {
        // body elements are not preserved after rollback
        if (isValid()) {
            _delete();
        }
    }
}
