/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.ArrayList;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.ThisExpression;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import java.util.List;
import org.netbeans.jmi.javamodel.JavaModelPackage;

/**
 *
 * @author  Martin Matula
 */
public abstract class ThisExpressionImpl extends ExpressionImpl implements ThisExpression {
    private MultipartId className;

    /** Creates a new instance of ThisExpressionImpl */
    public ThisExpressionImpl(StorableObject o) {
        super(o);
    }

    public MultipartId getClassName() {
        if (!childrenInited) {
            initChildren();
        }
        return className;
    }

    public void setClassName(MultipartId className) {
        objectChanged(CHANGED_CLASS_NAME);
        changeChild(getClassName(), className);
        this.className = className;
    }

    public List getChildren() {
        List result = new ArrayList(1);
        addIfNotNull(result, getClassName());
        return result;
    }

    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            if (tree.getSubTrees() != null) {
                className = (MultipartId) initOrCreate(className, tree.getSubTrees()[0]);
            } else {
                className = null;
            }
        }
        childrenInited = true;
    }

    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        MetadataElement parentClass = (MetadataElement) getClassName();
        if (parentClass != null) {
            buf.append(parentClass.getSourceText());
            buf.append("."); // NOI18N
        }            
        buf.append("this"); // NOI18N
        return buf.toString();
    }

    public void getDiff(List diff) {
        getChildDiff(diff, getParser(), getASTree().getSubTrees()[0], (MetadataElement) getClassName(), CHANGED_CLASS_NAME);
    }

    void setData(MultipartId className) {
        changeChild(null, className);
        this.className = className;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(className);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }

    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(className)) {
                setClassName((MultipartId)newElement);
            }
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getThisExpression().createThisExpression((MultipartId) duplicateElement(getClassName(), targetExtent));
    }
}
